#include <math.h>
#include <float.h>
#include <stdlib.h>
#include <stdio.h>
#include "fundefs.h"
#include "ran_pars.h"

int check( int n, double *a )
// --------------------------------------------------------------------
// -- Routine 'check' checks the correctness of the parallelly
//    generated random numbers by comparing them to a small sample
//    of the sequentially generated numbers.
// --------------------------------------------------------------------
{
   double *testar;
   double eps;
   long long x1, x2;
   int    i, ok = 0;
// --------------------------------------------------------------------
   eps = 10.0*DBL_EPSILON;
   testar   = calloc( n, sizeof( double ) );
   x1 = 2003;
   x2 = 2017;
   for( i = 0; i < 96; i++ ) {
      x1 = ( a1*x1 + c1 )%m1;
      x2 = ( a2*x2 + c2 )%m2;
   }
   for( i = 0; i < n; i++ ) {
      testar[i] = dran0( &x1, &x2 );
   }
   for( i = 0; i < n; i++ ) {
      if ( fabs( testar[i] - a[i] ) > eps ) ok++;
   }
   free( testar );
   return( ok );
}  // -- End of check
