void analhr( int n, int m, double *a, double *w )
// ---------------------------------------------------------------------
// -- 'analhr' does a 1-D Haar wavelet analysis on array 'a'.
//     Output in array 'w'.
// ---------------------------------------------------------------------
{
   int    i, j, k, n1;
   double av;
// ---------------------------------------------------------------------
   n1 = n;
   for( i = 0; i < m; i++ ) {
      n1 = n1/2;
      k  = 0;
      for( j = 0; j < 2*n1; j+= 2 ) {
         av      = 0.5*( a[j] + a[j+1] );
         w[k+n1] = a[j] - av;
         a[k]    = av;
         k++;
      }
   }
   w[0] = a[0];
}
