#include <math.h>
#include <stdio.h>
#include "fundefs.h"

void twiddle( int m, int n, double **ar, double **ai )
// ---------------------------------------------------------------------
// -- 'twiddle' does a complex multiplication with the appropriate
//    twiddle factors for the elements of 'ar' & 'ai' which represent
//    the Real and Imaginary parts of a 1-D 'm*n' length FFT,
//    factored as a sequence of 'n' FFTs of length 'm'.
// ---------------------------------------------------------------------
{
   int    i, j;
   double arg, fac, fr, fi, temp;
// ---------------------------------------------------------------------
   fac   = 8.0*atan( 1.0 )/( m*n );
#pragma omp parallel for private(i,j,arg,fr,fi,temp)
   for( i = 0; i < m; i++ ) {
      for( j = 0; j < n; j++ ) {
         arg       = ( j*i )*fac;
         fr        = cos( arg );
         fi        = sin( arg );
         temp      = ar[i][j]*fr - ai[i][j]*fi;
         ai[i][j]  = ar[i][j]*fi + ai[i][j]*fr;
         ar[i][j]  = temp;
      }
   }
} // -- End of twiddle
