#include "stdio.h"
#include "stdlib.h"

int intlog2( int n )
// ---------------------------------------------------------------------
// -- log2 determines the 2-log of an integer argument 'n'. If 'n' is
//    not an exact power of 2 this is reported as an error and the
//    function aborts.
// ---------------------------------------------------------------------
{
   int m, nl;
// ---------------------------------------------------------------------
   if ( n < 1 ) {
      printf( "***ERROR in function LOG2: Argument %d is < 1\n", n );
      abort();
   }
   if ( n == 1 ) return( 0 );
   nl = n;
   m  = 0;
   while ( nl > 1 ) {
      if ( ( nl%2 != 0 ) && ( nl != 1 ) ) {
         printf( "***ERROR in function LOG2: Argument %d is not a power of 2\n",
                 n );
         abort();
      }
      nl /= 2;
      m++;
   }
   return ( m );
} // -- End of intlog2
