#include "fundefs.h"
#include <math.h>

void sym7pre( int n1, int n2, int n3, double **a, double *b, double *fac )
/* --------------------------------------------------------------------
   -- sym7pre computes the inverse of D as used in the preconditioners.
      Also the elements of A and RHS b are adjusted.
   --------------------------------------------------------------------*/
{
   extern long flops;
   int i, inm, in12, l, n12, ntot;
// ---------------------------------------------------------------------
   n12  = n1*n2;
   ntot = n12*n3;
   fac[0] = 1.0/a[0][0];
   for( i = 1; i < ntot; ++i ) {
      inm = i - 1;
      fac[i] = a[i][0] - fac[inm]*a[inm][1]*a[inm][1];
   }
   for( i = n1; i < ntot; ++i ) {
      inm = i - n1;
      fac[i] -= fac[inm]*a[inm][2]*a[inm][2]; 
   }
   for( i = n12; i < ntot; ++i ) {
      inm = i - n12;
      fac[i] -= fac[inm]*a[inm][3]*a[inm][3];
   }
   for( l = 0; l < ntot; ++l ) {
      fac[l] = 1.0/fac[l];
   }
// ---------------------------------------------------------------------
// -- D-inverse is now complete, scale A and b.

   for( l = 0; l < ntot; ++l ) {
      a[l][0] *= fac[l];
      fac[l]   = sqrt( fac[l] );
      b[l]    *= fac[l];
   }
   for( i = 1; i < ntot; ++i ) {
      inm = i - 1;
      a[inm][1] = fac[i]*fac[inm]*a[inm][1];
   }
   for( i = n1; i < ntot; ++i ) {
      inm = i - n1;
      a[inm][2] = fac[i]*fac[inm]*a[inm][2];
   }
   for( i = n12; i < ntot; ++i ) {
      inm = i - n12;
      a[inm][3] = fac[i]*fac[inm]*a[inm][3];
   }
   flops += 25*ntot - 6*( n1 + n12 ) - 5;
} // -- End of sym7pre
