double dotpr( int n, double *x, double *y )
// ---------------------------------------------------------------------
// -- Dotproduct <x,y> of length n.
// ---------------------------------------------------------------------
{
   extern long flops;
   int    i, rest;
   double sum = 0.0;
// ---------------------------------------------------------------------
   rest = n - n%4;
   for( i = 0; i < rest; i +=4 ) {
      sum += x[i]*y[i]     + x[i+1]*y[+1] + x[i+2]*y[i+2] + x[i+3]*y[i+3];
   }
   for( i = rest; i < n; ++i ) {
      sum += x[i]*y[i];
   }
   flops += 2*n;
   return( sum );
} // -- End of dotpr
      
