double nrm2( int n, double *x )
// ---------------------------------------------------------------------
// -- Computes the L2 norm of vector x. (4 times unrolled.)
// ---------------------------------------------------------------------
{
   extern long int flops;

   int    i, rest;
   double sum = 0;
// ---------------------------------------------------------------------
   rest = n - n%4;
#pragma omp parallel for reduction(+:sum)
   for( i = 0; i < rest; i += 4 ) {
      sum = sum + x[i]*x[i] + x[+1]*x[i+1] + x[i+2]*x[i+2] + x[i+3]*x[i+3];
   }
   for( i = rest; i < n; ++i ) {
      sum = sum + x[i]*x[i];
   }
   flops += 2*n;
   return( sum );
} // -- End of nrm2
