#include <stdlib.h>

void lpolyn( int n, int nel, int m, int *indx, int *rowp, double *matvals,
             double *u, double *v, double *gamma )
// ---------------------------------------------------------------------
// -- Left polynomial preconditioner of order 'm'.
// ---------------------------------------------------------------------
{
   extern long int flops;

   double *w;
   int    i, j;
// ---------------------------------------------------------------------
   w = calloc( n, sizeof(double));
   for( i = 0; i < n; ++i ) {
      v[i] = gamma[m]*u[i];
   }
   for( i = 0; i < m; ++i ) {
      spmxv( n, nel, indx, rowp, matvals, v, w );
      for( j = 0; j < n; ++j ) {
         v[j] = v[j] - w[j];
         v[j] = v[j] + gamma[m-i-1]*u[j];
      } 
   }
   free( w );
   flops = flops + n*( 1 + 3*m );
} // -- End of lpolyn
