#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "fundefs.h"

void gendat( int n, int nelmts, int *indx, int *rowp, double *matvals,
             double *b )
// -----------------------------------------------------------------------
// -- 'gendat' generates the sparse matrix and the right hand side to be
//     of the linear system.
// -----------------------------------------------------------------------
{
   int    i, j, nelm, offset, shindx;
   int    x1 = 2006, x2 = 2003;
   double epr, offdiag;
// -----------------------------------------------------------------------

   epr   = (double)nelmts/(double)n;
   rinit( &x1, &x2 );
// -----------------------------------------------------------------------
// -- Generate the rowpointers subject to a variability of 20% in the
//     number of elements per row.    

   rowp[0] = 0;
   for( i = 1; i < n; i++ ) {
      rowp[i] = rowp[i-1] + ceil( epr*( 1.0 - 0.2*dran0( &x1, &x2 ) ) );
   }
// -----------------------------------------------------------------------
// --- Be sure that the last rowpointer is <= nelmts.

   rowp[n] = nelmts - 1;

// -----------------------------------------------------------------------
// --- Generate index array (and make sure there is a diagonal element).

   for( i = 0; i < nelmts; i++ ) {
      indx[i]    = (int)( n*dran0( &x1, &x2 ) );
   }
// for( i = 0; i <= n; i++ ) {
//    indx[rowp[i]] = i;
// }
// ----------------------------------------------------------------------
// --- Sort indices per row and adjust multiple indentical row entries.

   for( i = 0; i < n; i++ ) {
      nelm = rowp[i+1] - rowp[i];
      offdiag = 1.0/(double)( max( nelm - 1, 1 ) );
      for( j = rowp[i]; j <= rowp[i+1] - 1; j++ ) {
         matvals[j] = -0.97*offdiag;
      }
      for( j = rowp[i]; j <= rowp[i+1] - 1; j++ ) {
         if ( indx[j] == indx[j+1] ) {
            indx[j+1] = ( indx[j+1] >= n ) ? indx[j+1] - 2 : indx[j+1] + 1;
         }
      }
      iqsort( rowp[i], rowp[i+1]-1, indx );
// ----------------------------------------------------------------------
// --- Set diagonal elements to 1. The RHS is the sum of row elements.
//     So, x(i) should converge to 1 for row(i), (i = 1, n).

      shindx = rowp[i] + nelm/2;
      indx[shindx] = i;
      matvals[shindx] = 1.0;
      b[i] = 0.0;
      for( j = rowp[i]; j < rowp[i+1]; j++ ) {
         b[i] += matvals[j];
      }
   }
} // -- End of gendat
