double dotpr( int n, double *x, double *y )
// ---------------------------------------------------------------------
// -- Simple dotproduct implementation with 4-fault unrolling
// ---------------------------------------------------------------------
{
   extern long int flops;

   int    i, rest;
   double sum;
// ---------------------------------------------------------------------
   sum = 0.0;
   rest = n - n%4;
#pragma omp parallel for reduction(+:sum)
   for( i = 0; i < rest; i += 4 ) {
      sum = sum + x[i]*y[i] + x[i+1]*y[i+1] + x[i+2]*y[i+2] + x[i+3]*y[i+3];
   }
   for( i = rest; i < n; ++i ) {
      sum = sum + x[i]*y[i];
   }
   flops += 2*n;                              // -- Updating flop count.
   return ( sum );
} // -- End of dotpr
