int dswap( int n, double *dx, int incx, double *dy, int incy )
{
// ---------------------------------------------------------------------
// -- Purpose: Interchanges two vectors; uses unrolling for increments
//    equal to 1.

   int    i, ix, iy, m;
   double dtemp;
// ---------------------------------------------------------------------
// -- Test input parameters:
   if ( n <= 0 ) return 0;
   if ( incx == 0 || incy == 0 ) return 0;

// -- OK: get to work.
   if ( incx == 1 && incy == 1 ) {     // -- incx, incy equal 1.
      m = n%4;
      for( i = 0; i < m; i++ ) {
         dtemp = dx[i];
         dx[i] = dy[i];
         dy[i] = dtemp;
      }
      for( i = m; i < n; i += 4 ) {
         dtemp = dx[i];
         dx[i] = dy[i];
         dy[i] = dtemp;
         dtemp   = dx[i+1];
         dx[i+1] = dy[i+1];
         dy[i+1] = dtemp;
         dtemp   = dx[i+2];
         dx[i+2] = dy[i+2];
         dy[i+2] = dtemp;
         dtemp   = dx[i+3];
         dx[i+3] = dy[i+3];
         dy[i+3] = dtemp;
      }
   }
   else {                              // -- incx or incy != 1.
      ix = 0; iy = 0;
      if ( incx < 0 ) ix = (-n + 1)*incx;
      if ( incy < 0 ) iy = (-n + 1)*incy;
      for( i = 0; i < n; i++ ) {
         dtemp  = dx[ix];
         dx[ix] = dy[iy];
         dy[iy] = dtemp;
         ix = ix + incx;
         iy = iy + incy;
      }
   }
   return 0;
} // -- dswap
