void dlaswp( int n, double *a, int lda, int k1, int k2, int *ipvt, int incx )
// ------------------------------------------------------------------------
// -- 'dlaswp' performs a series of row interchanges on matrix a'.
//    Row interchanges are done for rows k1 through k2.
// ------------------------------------------------------------------------
{
   int i, ip, ix;
// ------------------------------------------------------------------------
   if ( incx == 0 ) return;
   ix = ( incx > 0 ) ? k1 : ( 1 - k2 )*incx;
   if ( incx == 1 ) {
      for( i = k1; i <= k2; i++ ) {
         ip = ipvt[i];
         if ( ip != i ) dswap( n, a+i*lda, 1, a+ip*lda, 1 );
      }
   }
   else if ( incx > 1 ) {
      for( i = k1; i <= k2; i++ ) {
         ip = ipvt[ix];
         if ( ip != i ) dswap( n, a+i*lda, 1, a+ip*lda, 1 );
         ix = ix + incx;
      }
   }
   else if ( incx < 0 ) {
      for( i = k2; i >= k1; i-- ) {
         ip = ipvt[ix];
         if ( ip != i ) dswap( n, a+i*lda, 1, a+ip*lda, 1 );
         ix = ix + incx;
      }
   }
}
