#include "dfmaxmin.h"
#include "fundefs.h"

int dgetrs( char *trans, int n, int nrhs, double *a, int lda, int *ipiv,
            double *b, int ldb, int info )
{
    /* Local variables */
    extern int lsame( char *, char * );
    extern int dtrsm( char *, char *, char *, char *, int, int, double,
                      double *, int, double *, int ),
               xerbla( char *, int ),
               dlaswp( int, double *, int, int, int, int *, int );
    int mtest, notran;

/*  -- LAPACK routine (version 3.1)
       Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
       November 2006 */

/*  Purpose
    =======
    DGETRS solves a system of linear equations
       A * X = B  or  A' * X = B
    with a general N-by-N matrix A using the LU factorization computed
    by DGETRF.

    Arguments
    =========
    TRANS   (input) CHARACTER*1
            Specifies the form of the system of equations:
            = 'N':  A * X = B  (No transpose)
            = 'T':  A'* X = B  (Transpose)
            = 'C':  A'* X = B  (Conjugate transpose = Transpose)
    N       (input) INTEGER
            The order of the matrix A.  N >= 0.
    NRHS    (input) INTEGER
            The number of right hand sides, i.e., the number of columns
            of the matrix B.  NRHS >= 0.
    A       (input) DOUBLE PRECISION array, dimension (LDA,N)
            The factors L and U from the factorization A = P*L*U
            as computed by DGETRF.
    LDA     (input) INTEGER
            The leading dimension of the array A.  LDA >= max(1,N).
    IPIV    (input) INTEGER array, dimension (N)
            The pivot indices from DGETRF; for 1<=i<=N, row i of the
            matrix was interchanged with row IPIV(i).
    B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
            On entry, the right hand side matrix B.
            On exit, the solution matrix X.
    LDB     (input) INTEGER
            The leading dimension of the array B.  LDB >= max(1,N).
    INFO    (output) INTEGER
            = 0:  successful exit
            < 0:  if INFO = -i, the i-th argument had an illegal value
========================================================================= */
// -- Test the input parameters. 

   info = 0;
   mtest = max( 1, n );
   notran = lsame( trans, "N" );
   if ( !notran && !lsame( trans, "T" ) && !lsame( trans, "C" ) ) info = -1;
   else if ( n < 0 ) info = -2;
   else if ( nrhs < 0 ) info = -3;
   else if ( lda < mtest ) info = -5;
   else if ( ldb < nrhs ) info = -8;
   if ( info != 0 ) {
      xerbla( "DGETRS", -info );
      return 0;
   }

// -- Quick return if possible.
   if ( n == 0 || nrhs == 0 ) return 0;
   if ( notran ) {

// -- Solve A * X = B. 
// -- Apply row interchanges to the right hand sides. 
      dlaswp( nrhs, b, 1, 0, n-1, ipiv, 1 );

// -- Solve L*X = B, overwriting B with X. 
      dtrsm( "Left", "Lower", "No transpose", "Unit", n, nrhs, 1.0, a,
             lda, b, ldb );

// -- Solve U*X = B, overwriting B with X. 
      dtrsm( "Left", "Upper", "No transpose", "Non-unit", n, nrhs, 1.0, a,
             lda, b, ldb );
   }
   else {

// -- Solve A' * X = B. 
// -- Solve U'*X = B, overwriting B with X. 
      dtrsm( "Left", "Upper", "Transpose", "Non-unit", n, nrhs, 1.0, a,
             lda, b, ldb );

// -- Solve L'*X = B, overwriting B with X. 
      dtrsm( "Left", "Lower", "Transpose", "Unit", n, nrhs, 1.0, a,
             lda, b, ldb );

// -- Apply row interchanges to the solution vectors. 
      dlaswp( nrhs, b, 1, 0, n-1, ipiv, -1 );
   }
   return 0;
} // -- End of dgetrs
