#include <stdio.h>

#define max(a,b)( ((a) > (b)) ? (a) : (b) )

void prtspeed( int m, int n, double time1, double time2, int ok1, int ok2,
               int nops )
{
   double speed1, speed2;
// -----------------------------------------------------------------
   speed1 = 1.0e-6*nops/max( time1, 1.0e-9 );
   speed2 = 1.0e-6*nops/max( time2, 1.0e-9 );
   printf( "%5d |%5d |%11.4g |%11.4g | ", m, n, time1, speed1 );
   if ( ok1 == 0 )
      printf( " T |" );
   else
      printf( " F |" );
   printf( "%11.4g |%11.4g | ", time2, speed2 );
   if ( ok2 == 0 )
      printf( " T |\n" );
   else
      printf( " F |\n" );
}
