#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"

int main()
{ 
   int      lda, m, n;
   int      ok1, ok2, nops, nrep;
   int      i;
   int      nprocs;
   double   **a, *b, *c;
   double   time1, time2;
   FILE     *inl;
// ------------------------------------------------------------------------
   state( "mod2a" );
#pragma omp parallel
   nprocs = omp_get_num_threads();
   printf( "No. of proc.s = %d\n\n", nprocs );
   prthead();
   inl = fopen( "mod2a.in", "r" );
   while( ( fscanf( inl, "%d%d%d\n", &m, &n, &nrep ) != EOF ) ){
      lda = n + 1;
      a = makmat( m, lda );
      b = calloc( lda, sizeof( double ) );
      c = calloc( m, sizeof( double ) );
      gendat( lda, a, b, m, n );
      time1 = cclock();
      for( i = 0; i < nrep; i++ ){
         mvddot( a, b, c, m, n ); 
      }
      time1 = cclock() - time1;
      ok1   = check( c, m, n );
      setval( m, c, 0.0 );
      time2 = cclock();
      for( i = 0; i < nrep; i++ ){
         mvaxpy( a, b, c, m, n ); 
      }
      time2 = cclock() - time2;
      ok2   = check( c, m, n );
      time1 = time1/nrep;
      time2 = time2/nrep;
      nops  = 2*n*m;
      prtspeed( m, n, time1, time2, ok1, ok2, nops );
      free( b );
      free( c );
      delmat( m, a );
   }
   printf( "---------------------------------------------------" );
   printf( "-------------------------\nRan OK\n" );
}
