#include <stdio.h>
#include "fundefs.h"

void wrtab( int maxi, double tab[][34], int nn, int *narr, char **ident,
            double xint[][2], double yint[2] )
// ---------------------------------------------------------------------
// -- wrttab writes table of results for program mod1f.
// ---------------------------------------------------------------------
{
   const int nfmax = 100, nmax = 50, inn = 4;
   int       i, i1, i2, j, k, m, n12;
   double    dt, t12;
   char      form1[37], form2[41];
// ---------------------------------------------------------------------
   i1 = 0;
   for( k = 1; k <= 10; ++k ) {                  // -- At most 10 pages.
// ---------------------------------------------------------------------
// -- Print heading

      printf( "------------------------------------------------------" );
      printf( "-----------------------\n" );
      printf( "\n" );
      printf( "Performance rates in Mega-function-calls/sec.\n" );
      if ( k > 1 ) printf( "(Continued)\n\n" );
      else printf( "\n" );
// ---------------------------------------------------------------------
// -- Write title line for table.

      i2 = min( nn, i1 + inn );
      if ( i2 < nn ) {
         printf( "                n =             %9d%9d%9d%9d%9d\n\n",
                 narr[i1], narr[i1+1], narr[i1+2], narr[i1+3], narr[i1+4] );
      }
      else {
         printf( "                n =             %9d%9d%9d%9d  n1/2\n\n",
                 narr[i1], narr[i1+1], narr[i1+2], narr[i1+3] );
      }
// ---------------------------------------------------------------------
// -- Write table.

      for( m = 0; m < maxi; ++m ) {
         if ( i2 < nn ) {                             // -- Without n1/2
            printf( " %s(%10.3e,%10.3e)%9.3f%9.3f%9.3f%9.3f%9.3f\n",
                     ident[m], xint[m][0], xint[m][1],
                     tab[m][i1], tab[m][i1+1], tab[m][i1+2], tab[m][i1+3],
                     tab[m][i1+4] );
            if ( m == 2 )
               printf( "         (%10.3e,%10.3e)\n", yint[0], yint[1] );
         }   
         else {                                       // -- With n1/2
            t12 = tab[m][nn-1]/2;
            for( j = nn - 1; j >= 0; --j ) {
               if ( tab[m][j] < t12 ) {
                  dt = tab[m][j+1] - tab[m][j];
                  if ( dt > 0 ) {
                     n12 = narr[j] + ( narr[j+1] - narr[j] )*
                                     ( ( t12 - tab[m][j] )/dt );
                  }
                  else n12 = narr[j];
                  goto L10;
               }
            }
            n12 = 0;
L10:        printf( " %s(%10.3e,%10.3e)%9.3f%9.3f%9.3f%9.3f% 5d\n",
                     ident[m], xint[m][0], xint[m][1],
                     tab[m][i1], tab[m][i1+1], tab[m][i1+2], tab[m][i1+3],
                     n12 );   
            if ( m == 2 )
               printf( "         (%10.3e,%10.3e)\n", yint[0], yint[1] );
         }
         if ( m ==  2 || m ==  5 || m ==  8 || m == 11 || m == 15 ||
              m == 19 || m == 24 || m == 28 || m == 32 ) printf( "\n" );
      }
      if ( i2 >= nn ) return;
      i1 = i2 + 1;
   }
} // -- End of wrtab 

