#define NORM 5.4210108624275221e-20
#define L1   18446744073709551614UL
#define L2   18446744073709551104UL
#define L3   18446744073709547520UL
#define L4   18446744073709420544UL
#define L5   18446744073701163008UL

long z1, z2, z3, z4, z5;

void setrand( int seed )
{
   long lseed;

   // --- Initialise rand64.

   lseed = (long) seed;
   z1 = lseed; z2 = z1 + 4087; z3 = z2 + 319; z4 = z3 + 1881; z5 = z4 + 13257;
}

double rand64( void )
{
    unsigned long b;
    
    b  = ((( z1 <<  1 ) ^ z1 ) >> 53 );
    z1 = ((( z1 & L1 ) << 10 ) ^ b );
    b  = ((( z2 << 24 ) ^ z2 ) >> 50 );
    z2 = ((( z2 & L2 ) <<  5 ) ^ b );
    b  = ((( z3 <<  3 ) ^ z3 ) >> 23 );
    z3 = ((( z3 & L3 ) << 29 ) ^ b );
    b  = ((( z4 <<  5 ) ^ z4 ) >> 24 );
    z4 = ((( z4 & L4 ) << 23 ) ^ b );
    b  = ((( z5 <<  3 ) ^ z5 ) >> 33 );
    z5 = ((( z5 & L5 ) <<  8 ) ^ b );
    
    return( ( z1 ^ z2 ^ z3 ^ z4 ^ z5 )*NORM + 0.5 );
}
