#include <float.h>
#include <math.h>
#include "fundefs.h"

void efvec( int maxi, int mrep, double tab[][34], int nn, int *narr,
            char **ident, double xint[][2], double yint[2] )
// -------------------------------------------------------------------------
// -- Function efvec calculates the speed of the intrinsic functions on
//    vectors of arguments.
// -------------------------------------------------------------------------
{
   double factor = 1.0e-6, pi = 3.14159265358979, onep5 = 1.5;
   int    i, j, l, m, n, nrep;
   double dt, t1, t2, ovhd;
   double a, b, c, eps;
   double x[30000], y[30000];
   int    it;
   double beta, xmax, xmin; 
   double f[30000];
// -------------------------------------------------------------------------
// -- Set parameters.

   xmax = DBL_MAX;
   xmin = DBL_MIN;
   beta = DBL_MANT_DIG;
   it   = FLT_RADIX;
// -------------------------------------------------------------------------
   m = 0;
   m++;
   if ( m > maxi ) return;
   a = 0.5;
   b = 1.0;
   ident[m-1] = "xsq**1.5";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      for( i = 0; i < n; ++i ) {
         x[i] = x[i]*x[i];
      }
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = pow( x[i], onep5 );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 1.0;
   b = exp( log( xmax )/3.0 );
   ident[m-1] = "xsq**1.5";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      for( i = 0; i < n; ++i ) {
         x[i] = x[i]*x[i];
      }
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = pow( x[i], onep5 );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.01;
   b = 10.0;
   c = max( log( xmax ), -log( xmin ) )/log( 100.0 );
   ident[m-1] = "x**y    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   yint[0]      = -c;
   yint[1]      = c;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      argy( -c, c, n, y );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = pow( x[i], y[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.0;
   b = 0.5*pi;
   ident[m-1] = "Sin     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = sin( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 6.0*pi;
   b = a + 0.5*pi;
   ident[m-1] = "Sin     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = sin( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 7.0*pi;
   b = a + 0.5*pi;
   ident[m-1] = "Cos     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = cos( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.5;
   b = 1.0;
   ident[m-1] = "Sqrt    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = sqrt( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 1.0;
   b = 2.0;
   ident[m-1] = "Sqrt    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = sqrt( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 1.0;
   b = xmax;
   ident[m-1] = "Sqrt    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = sqrt( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = -0.5*log( 2.0 ) + 1.0/16.0;
   b =  0.5*log( 2.0 );
   ident[m-1] = "Exp     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = exp( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = -5.0*log( 2.0 );
   b =  log( 4.0*xmin*pow( beta, it ) );
   ident[m-1] = "Exp     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = exp( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 10.0*log( 2.0 );
   b = max( 10.0*a, log( 0.9*xmax ) );
   ident[m-1] = "Exp     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = exp( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   eps = 1.0;
   for( i = 1; i <= it/3; ++i ) {
      eps = eps/beta;
   }
   a = 1.0 - eps;
   b = 1.0 + eps;
   ident[m-1] = "Log     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = log( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = sqrt( 0.5 );
   b = 15.0/16.0;
   ident[m-1] = "Log     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = log( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = sqrt( 0.1 );
   b = 0.9;
   ident[m-1] = "Log10   ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = log10( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 16.0;
   b = 240.0;
   ident[m-1] = "Log     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = log( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.0;
   b = pi/4.0;
   ident[m-1] = "Tan     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = tan( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = pi*0.875;
   b = pi*1.125;
   ident[m-1] = "Tan     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = tan( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 6.0*pi;
   b = a + 0.25*pi;
   ident[m-1] = "Tan     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = tan( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 6.0*pi;
   b = a + 0.25*pi;
   ident[m-1] = "Cot     ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = cot( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = -0.125;
   b =  0.125;
   ident[m-1] = "Asin    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = asin( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = -0.125;
   b =  0.125;
   ident[m-1] = "Acos    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = acos( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.75;
   b = 1.0;
   ident[m-1] = "Asin    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = asin( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.75;
   b = 1.0;
   ident[m-1] = "Acos    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = acos( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = -1.0;
   b = -0.75;
   ident[m-1] = "Acos    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = acos( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = -1.0/16.0;
   b =  1.0/16.0;
   ident[m-1] = "Atan    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = atan( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 1.0/16.0;
   b = 2.0 - sqrt( 3.0 );
   ident[m-1] = "Atan    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = atan( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 2.0 - sqrt( 3.0 );
   b = sqrt( 2.0 ) - 1.0;
   ident[m-1] = "Atan    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = atan( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = sqrt( 2.0 ) - 1.0;
   b = 1.0;
   ident[m-1] = "Atan    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = atan( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.0;
   b = 0.5;
   ident[m-1] = "Sinh    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = sinh( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.0;
   b = 0.5;
   ident[m-1] = "Cosh    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = cosh( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 3.0;
   b = log ( xmax );
   ident[m-1] = "Sinh    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = sinh( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 3.0;
   b = log ( xmax );
   ident[m-1] = "Cosh    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = cosh( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.125;
   b = 0.5*log ( 3.0 );
   ident[m-1] = "Tanh    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = tanh( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
// -------------------------------------------------------------------------
   m++;
   if ( m > maxi ) return;
   a = 0.125 + 0.5*log( 3.0 );;
   b = log ( 2.0 ) + ( it + 1 )*log( beta )*0.5;
   ident[m-1] = "Tanh    ";
   xint[m-1][0] = a;
   xint[m-1][1] = b;
   for( l = 0; l < nn; ++l ) {
      n = narr[l];
      nrep = mrep/n;
      argx( a, b, n, x );
      t1 = cclock();
      for( j = 1; j <= nrep; ++j ) {
#pragma omp parallel for
         for( i = 0; i < n; ++i ) {
            f[i] = tanh( x[i] );
         }
         ddummy( f, j );
      }
      t2 = cclock() - t1;
// -- Correct for overhead.
      ovhd = cclock();
      for( j = 1; j <= nrep; ++j ) {
        ddummy( f, j );
      }
      dt = ( t2 - cclock() + ovhd )/nrep;
      if ( dt > 0.0 ) tab[m-1][l] = ( factor/dt )*n;
      else tab[m-1][l] = 999.999;
   }
} // -- End of efvec
