#include <stdlib.h>
#include <float.h>
#include <stdio.h>
#include "fundefs.h"

void dmerge( int n, int np, double *ddata, int *ptr )
// ---------------------------------------------------------------------
// -- dmerge does an np-way merge of sorted double arrays.
// ---------------------------------------------------------------------
{
   int    ds, i, is, j, pop;
   int    *ub;
   double *head, *w;
   double maxd;
// ---------------------------------------------------------------------
   is    = sizeof(int);
   ds    = sizeof(double);
   head = calloc( np, ds );
   ub   = calloc( np, is );
   w    = calloc( n, ds ); 
   maxd = DBL_MAX;           // -- Sentinel value for array "head".
// ---------------------------------------------------------------------
// -- Determine upperbounds of partitions of idata.

   for( i = 0; i < np; ++i ) {
      ub[i] = ptr[i+1] - 1;
   }
// ---------------------------------------------------------------------
// -- Merge.

   for( j = 0; j < n; ++j ) {
      for( i = 0; i < np; ++i ) {
         if ( ptr[i] <= ub[i] ) {
            head[i] = ddata[ptr[i]];
         }
         else {
            head[i] = maxd;
         }
      }
      w[j] = d_minval( np, head );
      pop  = d_minloc( np, head );
      ptr[pop] = min( ptr[pop] + 1, ub[pop] + 1 );
   }
   cp_arrdd( n, w, ddata );
   free( head );
   free( ub );
   free( w );
} // -- End of dmerge.
