#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"

const long long m1 = 259200LL, a1 = 7141LL, c1 = 54773LL,
                m2 = 134456LL, a2 = 8121LL, c2 = 28411LL;
long long       ak1, ak2, ck1, ck2;

int main()
{
   int       me, n, ok, nprocs;
   long long x1, x2;
   double    gtime, nops;
   double    *a, *time;
   FILE      *inl;
// ------------------------------------------------------------------------
   state( "mod2h" );
#pragma omp parallel
   nprocs = omp_get_num_threads();
   prthead( nprocs );
   inl = fopen( "mod2h.in", "r" );
   while( ( fscanf( inl, "%d\n", &n) != EOF ) ) {
// ------------------------------------------------------------------------
// --- Partition problem and allocate.

      a    = calloc( n, sizeof( double ) );
      time = calloc( nprocs, sizeof(double) );
#pragma omp parallel for private(me,x1,x2)
      for( me = 0; me < nprocs; ++me) {
         x1 = 2003;                         // -- Seeds for random process.
         x2 = 2017;
         time[me] = cclock();
         rinit( n, a, nprocs, me, &x1, &x2 );
         ranfil( n, a, nprocs, me, x1, x2 );
         time[me] = cclock() - time[me];
      }
      ok = check( n, a ); 
      gtime = maxval( nprocs, time );
      nops = 1.0e-6*(double)n;
      gtime = max( gtime, 1.0e-9 );
      nops = nops/gtime;
      prtspeed( n, gtime, nops, ok );
      free( a ); free( time );
    }
    printf( "---------------------------------------------\n" );
}
