#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"
#define  Max( a, b ) ( ( a > b ) ? a : b )

int main()
// ---------------------------------------------------------------------
// -- Purpose of the program
//    ----------------------
//    This program performs 2-D Haar wavelet transforms as used in data
//    compression. Data are generated internally and, subsequently, a
//    wavelet analysis and sythesis are performed. The time and Mflop/s
//    for an analysis/synthesis pair are determined.
// ---------------------------------------------------------------------
{
      double **a1, **a2, **w1, **w2;
      double speed, time;
      int    irep, m, n, nops, nrep;
      int    ok;
      FILE   *inl;
// ---------------------------------------------------------------------
      state( "mod2g" );
      prthead();
      inl = fopen( "mod2g.in", "r" );
      while( fscanf( inl, "%d%d%d\n", &m, &n, &nrep ) != EOF ) {
         a1 = makmat( m, n );
         a2 = makmat( n, m );
         w1 = makmat( m, n );
         w2 = makmat( n, m );
         nops = 5*( n*( m - 1 ) + m*( n - 1 ) );
         gendat( m, n, a1 );
         time = cclock();
         for( irep = 1; irep <= nrep; irep++ ) {
            anhr2d( m, n, a1, a2, w1, w2 );
            synhr2d( m, n, a1, a2, w1, w2 );
         }
         time  = cclock() - time;
         speed = ( 1.0e-6*nops )*nrep/Max( time, 1.0e-9 );
         gendat( m, n, w1 );
         ok = check( m, n, a1, w1 );
         prtspeed( m, n, time, speed, ok );
         delmat( m, a1 ); delmat( m, w1 );
         delmat( n, a2 ); delmat( n, w2 );
   }
   printf( "--------------------------------------------------------\n" );
   printf( "Ran OK\n" );
}
