void ltrans( int m, int n, double **ar, double **ai,
                           double **wr, double **wi )
{
// ---------------------------------------------------------------------
// --- 'ltrans' transposes the arrays 'ar[m][n]' and 'ai[m][n]' and
//     leaves them in the arrays 'wr[n][m]' and 'wi[n][m]'.
// ---------------------------------------------------------------------
   int i, j;
// ---------------------------------------------------------------------
#pragma omp parallel for private(i,j)
   for( i = 0; i < m; i++ ) {
      for( j = 0; j < n; j++ ) {
         wr[j][i] = ar[i][j];
         wi[j][i] = ai[i][j];
      }
   }
}
