#include <math.h>

void gendat( int m, int n,  double **ar, double **ai )
// ---------------------------------------------------------------------
// --- Routine 'gendat' generates  the test data for the FFT:
//     One complete cosine cycle in the Real part of the data.
//     Zero in the imaginary part of the data.
// ---------------------------------------------------------------------
{
   int    i, j, nbase, nr;
   double arg, fac;
// ---------------------------------------------------------------------
   fac   = 8.0*atan( 1.0 )/(double)(m*n);

   for( j = 0; j < m; j++ ) {
      for( i = 0; i < n; i++ ) {
         arg = ( j*n + i )*fac;
         ar[j][i] = cos( arg );
         ai[j][i] = 0.0;
      }
   }
}
