#include <stdio.h>
#include <math.h>

int check( int nr, int nc, double **a, double **b, double err )
//----------------------------------------------------------------------
//--- 'check' checks the errors made in the transformation of a
//    complex-to-complex FFT. 'check' is specific for the input
//    of this program.
//    The Real part is a full cycle of a cosine signal and the
//    Imaginary part is 0.0 everywhere.
//    The resulting transform should show values of N/2 for
//    A[1] and A[N-1]. All other entries should be 0.0.
//    This is checked below with a Floating-Point error
//    margin of ERR = ( 10.0*N Log N )*EPS, with EPS the
//    Floating-Point spacing of the machine tested.
//--- The Real part of A is stored in A[0], ..., A[N-1];
//    The Imaginary part in B[0], ..., B[N-1].
//--- This variant is using a factorised 2-D approach, so A and B
//    contain the results in 2-D matrices of n = nr*nc.
//----------------------------------------------------------------------
{
   int    i, j;
   int    ok = 0;
   double dnh;
//----------------------------------------------------------------------
// -- First check all imaginary elements (all should be 0).
   
   for( i = 0; i < nr; ++i ) {
      for( j = 0; j < nc; ++j ) {
         if ( fabs( b[i][j] ) > err ) {
            printf( "Imaginary element b[%d]= %g > err = %g\n", i*nc + j,
                     b[i][j], err );
            ok++;
          }
       }
   } 
   if ( fabs( a[0][0] ) > err ) {
      printf( "First Real element a[0][0] = %g > err = %g\n", a[0][0], err );
      ok++;
   }
   for( i = 2; i < nr; i++ ) {
      if ( fabs( a[0][i] ) > err ) {
         printf( "Real element a[%d] = %g > err = %g\n", i, a[0][i], err );
         ok++;
      }
   }
   for( j = 1; j < nr - 1; ++j ) {
      for( i = 0; i < nc; i++ ) {
         if ( fabs( a[j][i] ) > err ) {
            printf( "Real element a[%d] = %g > err = %g\n", j*nc + i, a[j][i],
                     err );
            ok++;
         }
      }
   }
   for( i = 0; i < nc - 1; i++ ) {
      if ( fabs( a[nr-1][i] ) > err ) {
         printf( "Real element a[%d] = %g > err = %g\n",  ( nr - 1 )*nc + i,
                  a[nr-1][i], err );
         ok++;
      }
   }
   dnh = (double)( nr*nc/2 );
   if ( fabs( a[0][1] - dnh ) > err ) {
      printf( "Second Real element, a[1] = %g != %g\n", a[0][1], dnh );
      ok++;
   }
   if ( fabs( a[nr-1][nc-1] - dnh ) > err ) {
      printf( "Real element, a[%d] = %g != %g\n", nr*nc - 1, a[nr-1][nc-1],
               dnh );
      ok++;
   }
   return ( ok );
}     
