#include <stdlib.h>
#include "fundefs.h"

void sym7pol( int n1, int n2, int n3, int m, double **a, double *rmr, double *q,
              double *x, double *y, double *gamma )
// ---------------------------------------------------------------------
// -- Polynomial (Neumann) preconditioner.
// ---------------------------------------------------------------------
{
   extern long flops;
   double *t, *w;
   int    i, j, l, n12, ntot;
// ---------------------------------------------------------------------
   n12  = n1*n2;
   ntot = n12*n3;
   t    = calloc( ntot, sizeof(double ) );
   w    = calloc( ntot, sizeof(double ) );
#pragma omp parallel for
   for( l = 0; l < ntot; ++l ) {
      t[l] = q[l]*x[l];
      y[l] = gamma[m]*t[l];
   }
   for( i = 0; i < m; ++i ) {
      sym7mxv( n1, n2, n3, a, y, w );
#pragma omp parallel for
      for( l = 0; l < ntot; ++l ) {
         w[l] *= q[l];
         y[l] -= w[l];
         y[l] += gamma[m-i]*t[l];
      }
   }
// ---------------------------------------------------------------------
// -- Computation of (r,Mr) where M is the preconditioner.

   *rmr    = nrm2( ntot, y );
   flops += ntot*( 2 + 4*m );
} // -- End of sym7pol
