#include "fundefs.h"

void sym7gen( int ntot, double **a, double *b )
/*----------------------------------------------------------------------
  --- sym7gen generates the 4 upper diagonals of a 7-diagonal symmetric
      matrix to be solved by a GC iterative solver. Also the RHS, b is
      generated.
      double a[n1*n2*n3][0:3] : Matrix to be generated.
      double b[n1*n2*n3]      : Right hand side.
  ----------------------------------------------------------------------*/
{
   int    i, j;
   int    x[2];
   double offdg;
// ---------------------------------------------------------------------
   x[0] = 2005;
   x[1] = 1995;
   rinit( x );
   for( j = 1; j <= 3; ++j ) {
      for( i = 0; i < ntot; ++i ) {
         a[i][j] = dran0( x );
      }
   }
   for( i = 0; i < ntot; ++i ) {
      offdg   = a[i][1] + a[i][2] + a[i][3];
      a[i][0] = 2.0*offdg;
   }
   for( i = 0; i < ntot; ++i ) {
      a[i][1] = -a[i][1]/a[i][0]; 
      a[i][2] = -a[i][2]/a[i][0]; 
      a[i][3] = -a[i][3]/a[i][0]; 
      a[i][0] = 1.0;
      b[i]    = a[i][1] + a[i][2] + a[i][3] + a[i][0] + a[i][1] + a[i][2]
              + a[i][3];
   }
} // -- End of sym7gen
