double dran0( int *x )
// ---------------------------------------------------------------------
// -- dran0 produces uniformly distributed pseudo random numbers by
//    linear congruence.
// ---------------------------------------------------------------------
{
   const int    m1 = 259200, a1 = 7141, c1 = 54773,
                m2 = 134456, a2 = 8121, c2 = 28411;
   const double rm1 = 1.0/m1, rm2 = 1.0/m2;
// ---------------------------------------------------------------------
   x[0] = ( a1*(x[0]) + c1 )%m1;
   x[1] = ( a2*(x[1]) + c2 )%m2;
   return( ( (double)x[0] + (double)x[1]*rm2 )*rm1 );
} // -- End of dran0
