#include <math.h>
#include "fundefs.h"

double rotb( double c, double s )
// ---------------------------------------------------------------------
// --  rotb stores rotation factors 'arg' according to sine/cosine terms
//     of Givens transformation (used in rgmres).
// ---------------------------------------------------------------------
{
   extern long int flops;
   double arg;
// ---------------------------------------------------------------------
   if ( c == 0.0 ) arg = 1.0;
   else if ( fabs( s ) < fabs( c ) ) {
      arg = 0.5*s*sign( 1.0, c );
      flops += 6;
   }
   else {
      arg = 2.0*sign(1.0, s )/c;
      flops += 5;
   }
   return( arg );
} 
