#include <math.h>

void givens( double a, double b, double *c, double *s )
// ---------------------------------------------------------------------
// -- Calculates rotation factors c & s from 'a' and 'b' for the Givens
//    transformation (used in rgmres).
// ---------------------------------------------------------------------
{
   extern long int flops;

   double fac;
// ---------------------------------------------------------------------
   if ( b == 0.0 ) {
      *c = 1.0;
      *s = 0.0;
   }
   else if ( fabs( b ) < fabs( a )  ) {
      fac = -a/b;
      *s  = 1.0/sqrt( 1.0 + fac*fac );
      *c  = fac*(*s);
      flops += 13;
   }
   else {
      fac = -b/a;
      *c  = 1.0/sqrt( 1.0 + fac*fac );
      *s  = fac*(*c);
      flops += 13;
   }
} // -- End of givens
