#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"

int main()
{ 
   int      ncols, nrows, nelmts;
   int      i, j, k;
   int      *indx, *rowp;
   int      ok;
   double   *matvals, *invec, *outvec;
   double   fill, mflops, time;
   FILE     *inl;
// ------------------------------------------------------------------------
   state( "mod2as" );
   prthead();
   inl = fopen( "mod2as.in", "r" );
   while( ( fscanf( inl, "%d%d%d\n", &ncols, &nrows, &nelmts ) != EOF ) ) {
      indx    = calloc( nelmts, sizeof( int ) );
      rowp    = calloc( nrows, sizeof ( int ) );
      matvals = calloc( nelmts, sizeof ( double ) );
      invec   = calloc( ncols, sizeof ( double ) );
      outvec  = calloc( nrows, sizeof ( double ) );
      getmatvec( ncols, nrows, nelmts, indx, rowp, matvals, invec );
      time = cclock();
      spmxv( nrows, nelmts, indx, rowp, matvals, invec, outvec );
      time = cclock() - time;
      ok = check( ncols, nrows, nelmts, indx, rowp, outvec );
      mflops = 2.0*1.0e-6*(double)nelmts/time;
      fill   = 1.0e2*(double)nelmts/((double)(ncols*nrows));
      prtspeed( ncols, nrows, fill, time, mflops, ok ); 
      free( indx ); free( rowp ); free( matvals ); free( invec );
      free( outvec );
   }
   printf( "-------------------------------------------------------\n" );
   printf( "Ran OK\n" );
}
