#include <stdlib.h>
#include <stdio.h>

double rand64( void );

void getmatvec( int ncols, int nrows, int nelmts, int indx[], int rowp[],
                double matvals[], double invec[] )
{
// -----------------------------------------------------------------------
// -- 'getmatvec' generates the sparse matrix and the input vector to be
//    used for the multiplication.

   int    felprow, i, nvarelts;
// -----------------------------------------------------------------------
   felprow  = (int)(0.98*nelmts/nrows) + 1;
   nvarelts = felprow/2 + 1;
   setrand( 2003 );
// -----------------------------------------------------------------------
// -- Generate the rowpointers subject to a variability of 20% in the
//     number of elements per row.    

   rowp[0] = 1;
   for( i = 1; i < nrows; i++ ) {
      rowp[i] = rowp[i-1] + felprow +
                            (int)( nvarelts*( rand64() - 0.5 ) ) - 1;
   }
// -----------------------------------------------------------------------
// --- Be sure that the last rowpointer is <= nelmts.

   rowp[nrows-1] = ( rowp[nrows-1] <= nelmts ) ? rowp[nrows-1] : nelmts;

// -----------------------------------------------------------------------
// --- Generate index array 'indx' and array with matrix entries 'matvals'.

   for( i = 0; i < nelmts; i++ ) {
      indx[i]    = (int)( ncols*rand64() );
      matvals[i] = 1.0;
   }
   for( i = 0; i < nrows - 1; i++ ) {
      iqsort( rowp[i], rowp[i+1]-1, indx );
   }
   iqsort( rowp[nrows-1], nelmts, indx );

// -----------------------------------------------------------------------
// --- Generate input vector 'invec'.

   for( i = 0; i < ncols; i++ ) {
      invec[i] = 1.0;
   }
}
