#include <string.h>

void mvddot( double **a, double *b, double *c, int m, int n )
// ---------------------------------------------------------------------
// --- Routine 'mvddot' does a matrix-vector multiplication 'Ab = c'
//     using an dotproduct implementation.
// ---------------------------------------------------------------------
{
   int    i, j, mf;
   double t1, t2, t3, t4;
// ---------------------------------------------------------------------
   for( i = 0; i < m; i++ ) {
      c[i] = 0.0;
   }
   mf = m - m%4;
   for( i = 0 ; i < mf; i+= 4 ){
      t1 = 0.0; t2 = 0.0; t3 = 0.0; t4 = 0.0;
#pragma omp parallel for reduction(+:t1,t2,t3,t4)
      for( j = 0; j < n; j++ ){
         t1 = t1 + a[i][j]  *b[j];
         t2 = t2 + a[i+1][j]*b[j];
         t3 = t3 + a[i+2][j]*b[j];
         t4 = t4 + a[i+3][j]*b[j];
      }
      c[i] = t1; c[i+1] = t2; c[i+2] = t3; c[i+3] = t4;
   }
   mf = mf;
   for( i = mf; i < m; i++ ){
      t1 = 0.0;
#pragma omp parallel for reduction(+:t1)
      for( j = 0; j < n; j++ ){
         t1 = t1 + a[i][j]*b[j];
      }
      c[i] = t1;
   }
   mf = mf;
}
