void mvaxpy( double **a, double *b, double *c, int m, int n )
// ---------------------------------------------------------------------
// --- Routine 'mvaxpy' does a matrix-vector multiplication 'Ab = c'
//     using an axpy implementation.
// ---------------------------------------------------------------------
{
   int    i, j, nf;
// ---------------------------------------------------------------------
   for( i = 0; i < m; i++) {
      c[i] = 0.0;
   }
   nf = n - n%4;
   for( j = 0 ; j < nf; j+= 4 ){
#pragma omp parallel for
      for( i = 0; i < m; i++ ){
         c[i] = c[i] + a[i][j]  *b[j]   + a[i][j+1]*b[j+1]
                     + a[i][j+2]*b[j+2] + a[i][j+3]*b[j+3];
      }
   }
   for( j = nf; j < n; j++ ){
#pragma omp parallel for
      for( i = 0; i < m; i++ ){
         c[i] = c[i] + a[i][j]*b[j];
      }
   }
}
