      Program wvlt2d
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the EuroBen Efficiency Benchmark       ***
! ***                                                                ***
! *** Copyright: European Benchmark Group p/o                        ***
! ***            Utrecht University, High Perf. Computing Group      ***
! ***            P.O. Box 80195                                      ***
! ***            3508 TD Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad J. van der Steen                   ***
! *** Email: steen@phys.uu.nl                                        ***
! *** Date:  Spring 2001, modified Spring 2005                       ***
! **********************************************************************
! ----------------------------------------------------------------------
! --- Purpose of the program
!     ----------------------
!     This program performs 2-D Haar wavelet transforms as used in data
!     compression. Data are generated internally and, subsequently, a
!     wavelet analysis and sythesis are performed. The time and Mflop/s
!     for an analysis/synthesis pair are determined.
! ----------------------------------------------------------------------
      Use                      numerics
      Implicit                 None
      Real(l_), Allocatable :: a1(:,:), a2(:,:), w1(:,:), w2(:,:)
      Integer, Parameter    :: mxcase = 15
      Integer               :: nl1(mxcase), nl2(mxcase)
      Real(l_)              :: speed(mxcase), time1(mxcase)
      Real(l_)              :: wclock
      Integer               :: i, icase, n1, n2, ncase, nops, nrep
      Logical               :: ok(mxcase)

      Integer, Parameter    :: nmax = 50, k = 4
      Integer               :: ic
      Real(l_)              :: size(0:nmax-1), speedcase(0:nmax-1)
      Real(l_)              :: q(0:6,0:nmax+1), aw(0:3,0:3), d(0:3,0:3),
     &                         extra(0:1), result
      Real(l_), Parameter   :: eps = 5.0e-9_l_, fraction = 0.08_l_
      Real(l_)              :: low, up, tpp
      Real(l_)              :: tkn, bcoef
      Common /coeffs/          tkn(0:nmax+5), bcoef(0:nmax+1)
!
! --- External Functions
!     ------------------
      External                 autint, spoint, wclock
      Real(l_)              :: autint, spoint
! ----------------------------------------------------------------------
      ncase = 0
      Call state( 'wvlt2d  ' )
      Open( 1, File = 'wvlt2d.in' )
      Read( 1, * ) tpp
      Read( 1, * ) low, up
      Print 900, low, up, tpp
   10 Read( 1, *, End = 20 ) n1, n2, nrep
      ncase = ncase + 1
      If ( ncase > mxcase ) Then
         Print *, '*** No. of cases larger than mxcase (=15):',
     &            'Increase mxcase please to get all results.'
         ncase = mxcase
         Go To 20
      End If
      size(ncase-1) = Log( Real( n1*n2, l_ ) )
      nl1(ncase)    = n1
      nl2(ncase)    = n2
      Allocate( a1(n1,n2), a2(n2,n1), w1(n1,n2), w2(n2,n1) )
      nops = 5*(n2*(n1 - 1) + n1*(n2 - 1))
      Call gendat( a1, n1, n2 )
      time1(ncase) = wclock()
      Do i = 1, nrep
         Call anhr2d( a1, a2, w1, w2, n1, n2 )
         Call synhr2d( a1, a2, w1, w2, n1, n2 )
      End Do
      time1(ncase) = wclock() - time1(ncase)
      speed(ncase) = ( 1.0e-6_l_*nops )*nrep/
     &                 Max( time1(ncase), 1.0e-9_l_ )
      speedcase(ncase-1) = speed(ncase)
      Call gendat( w1, n1, n2 )
      ok(ncase) = .TRUE.
      Call check( w1, a1, n1, n2, ok(ncase) )
      Deallocate( a1, a2, w1, w2 )
      Go To 10
   20 Print 1000
      Do i = 1, ncase
         Print 1010, nl1(i), nl2(i), time1(i)/nrep, speed(i), ok(i)
      End Do
      ic = ncase
      Call bsplcf( size, speedcase, ic, k, 'FREE', extra, q, aw, d, tkn,
     &             bcoef )
      result = autint( spoint, Log( low ), Log( up ), eps )
      result = result/( Log( up - low )*tpp )
      Print 1020, result, fraction
      Print 1030
! ----------------------------------------------------------------------
  900 Format( '2-D Haar Wavelet Transform test:'/
     &        'Lower bound       =', g13.5/
     &        'Upper bound       =', g13.5/
     &        'Theor. Peak Perf. =', g13.5, ' Mflop/s'/
     &        '-----------------------------------------------',
     &        '-------------------' )
 1000 Format( '2-D Haar wavelet transform test:'/
     &        '-------------------------------------------------------'/
     &        '    Order   | Exec. Time  |    Speed    | Correctness |'/
     &        '  n1 |  n2  |     (s)     |  (Mflop/s)  |      OK     |'/
     &        '-------------------------------------------------------'
     &         )
 1010 Format( i4,' | ',  i4,' |', g12.5,' |', g13.5, '|    ', l3,
     &        '      |' )
 1020 Format( '-------------------------------------------------------',
     &         /'Fraction found = ', g11.4, '; Fraction required = ',
     &         g11.4 )
 1030 Format( '-------------------------------------------------------'
     &         )
! ----------------------------------------------------------------------
      End Program wvlt2d
