      Subroutine synthr( a, w, n, m )
! ---------------------------------------------------------------------
! --- Routine 'synthr' does a 1-D Haar wavelet systhesis. 'a' is input,
!     'w' is output array.
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: n, m
      Real(l_) :: a(n), w(n)

      Integer  :: i, j, j2, k, n1
      Logical  :: odd
! ---------------------------------------------------------------------
      n1 = 1
      odd = .TRUE.
      w(1) = a(1)
      Do i = 1, m
         If ( odd ) Then
            If ( n1 >= 4 ) Then
               Do j = 1, n1, 4
                  w(j*2-1) = a(j)   + a(j+n1)
                  w(j*2)   = a(j)   - a(j+n1)
                  w(j*2+1) = a(j+1) + a(j+n1+1)
                  w(j*2+2) = a(j+1) - a(j+n1+1)
                  w(j*2+3) = a(j+2) + a(j+n1+2)
                  w(j*2+4) = a(j+2) - a(j+n1+2)
                  w(j*2+5) = a(j+3) + a(j+n1+3)
                  w(j*2+6) = a(j+3) - a(j+n1+3)
               End Do
            Else If ( n1 >= 2 ) Then
               Do j = 1, n1, 2
                  w(j*2-1) = a(j)   + a(j+n1)
                  w(j*2)   = a(j)   - a(j+n1)
                  w(j*2+1) = a(j+1) + a(j+n1+1)
                  w(j*2+2) = a(j+1) - a(j+n1+1)
               End Do
            Else
               Do j = 1, n1
                  w(j*2-1) = a(j) + a(j+n1)
                  w(j*2)   = a(j) - a(j+n1)
               End Do
            End If
         Else
            If ( n1 >= 4 ) Then
               Do j = 1, n1, 4
                  a(j*2-1) = w(j)   + a(j+n1)
                  a(j*2)   = w(j)   - a(j+n1)
                  a(j*2+1) = w(j+1) + a(j+n1+1)
                  a(j*2+2) = w(j+1) - a(j+n1+1)
                  a(j*2+3) = w(j+2) + a(j+n1+2)
                  a(j*2+4) = w(j+2) - a(j+n1+2)
                  a(j*2+5) = w(j+3) + a(j+n1+3)
                  a(j*2+6) = w(j+3) - a(j+n1+3)
               End Do
            Else If ( n1 >= 2 ) Then
               Do j = 1, n1, 2
                  a(j*2-1) = w(j)   + a(j+n1)
                  a(j*2)   = w(j)   - a(j+n1)
                  a(j*2+1) = w(j+1) + a(j+n1+1)
                  a(j*2+2) = w(j+1) - a(j+n1+1)
               End Do
            Else
               Do j = 1, n1
                  a(j*2-1) = w(j) + a(j+n1)
                  a(j*2)   = w(j) - a(j+n1)
               End Do 
            End If
         End If
         n1 = n1 + n1
         odd = .NOT. odd
      End Do
      If ( m == 2*(m/2) ) w = a
! ---------------------------------------------------------------------
      End Subroutine synthr            
