      Subroutine analhr( a, w, n, m )
! ---------------------------------------------------------------------
! --- 'analhr' does a 1-D Haar wavelet analysis on array 'a'.
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None

      Integer  :: n, m
      Real(l_) :: a(n), w(n)

      Integer  :: i, j, k, n1
      Real(l_) :: av
! ---------------------------------------------------------------------
      n1 = n
      Do i = 1, m
         n1 = n1/2
         k = 1
         Do j = 1, 2*n1, 2
            av      = 0.5_l_*( a(j) + a(j+1) )
            w(k+n1) = a(j) - av
            a(k)    = av
            k       = k + 1
         End Do
      End Do
      w(1) = a(1)
! ---------------------------------------------------------------------
      End Subroutine analhr 
