      Subroutine sizoff( n1, n2, sizes, offset )
! ---------------------------------------------------------------------
! --- Routine 'sizoff' determines the sizes and offsets of a 2-D
!     array with dimensions 'n1' and 'n2' with respect to a 
!     distribution that is as even as possible on 'nodes' processors
!     ('nodes' being known from module 'dist_module').
!     Then the offsets for each local array with respect to the global
!     global array are determined.
! ---------------------------------------------------------------------
      Use     dist_module
      Integer n1, n2, sizes(0:nodes-1,2), offset(0:nodes-1,2)

      Integer i, k, non, nrest, rest
! ---------------------------------------------------------------------
      non   = n1/nodes
      rest  = Mod( n1, nodes )
      nrest = nodes - rest - 1
      Do i = 0, nodes - 1
         sizes(i,1) = non
         If ( i > nrest ) sizes(i,1) = non + 1
      End Do
      non   = n2/nodes
      rest  = Mod( n2, nodes )
      nrest = nodes - rest - 1
      Do i = 0, nodes - 1
         sizes(i,2) = non
         If ( i > nrest ) sizes(i,2) = non + 1
      End Do
      Do k = 1, 2
         offset(0,k) = 0
         Do i = 1, nodes - 1
            offset(i,k) = offset(i-1,k) + sizes(i-1,k)
         End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine sizoff 
