      Subroutine gtrans( a, at, n1, n2, size1, size2, ctime )
! ----------------------------------------------------------------------
! --- 'gtrans' does a global transpose of array 'a' and puts it in 
!     array 'at'.
! ----------------------------------------------------------------------
      Use         numerics
      Use         dist_module ! Contains # of proc.s & proc. no.s
      Implicit    None
      Include     'mpif.h'

      Integer  :: n1, n2, size1, size2
      Real(l_) :: a(n1,size2), at(n2,size1), ctime

      Real(l_) :: wrk(size2,n1)
      Real(l_) :: time
      Integer  :: actsiz(0:nodes-1,2), base(0:nodes-1,2)
      Integer  :: scnts(0:nodes-1), sdpls(0:nodes-1),
     &            rcnts(0:nodes-1), rdpls(0:nodes-1)
      Integer  :: ierr
! ----------------------------------------------------------------------
! --- Get distribution & offsets for a.

      Call sizoff( n1, n2, actsiz, base )
! ----------------------------------------------------------------------
! --- Do local transposition.

      Call ltrans( n1, actsiz(me,2), a, at )
! ----------------------------------------------------------------------
! --- Determine sizes and displacements of data to be sent.

      Call cntdpls( actsiz, scnts, sdpls, rcnts, rdpls )
! ----------------------------------------------------------------------
! --- Distribute appropriate blocks over the processors.

      time = MPI_Wtime()
      Call MPI_Barrier( MPI_Comm_world, ierr )
      Call MPI_AlltoAllv( at, scnts, sdpls, MPI_Real8,
     &                   wrk, rcnts, rdpls, MPI_Real8,
     &                   MPI_Comm_World, ierr )
      time  = MPI_Wtime() - time
      ctime = ctime + time
! ----------------------------------------------------------------------
! --- Do block transposition of the communicated data.
      Call btrans( wrk, actsiz(me,1), n2, actsiz, at )
! ----------------------------------------------------------------------
      End Subroutine gtrans           
