      Subroutine check( a, vsize, n1, n2, actsiz, base, ok )
! ---------------------------------------------------------------------
! --- Subroutine 'check' checks whether the two times transposed
!     matrix 'w' is identical to the original 'a' within the
!     precision 'eps'.
! ---------------------------------------------------------------------
      Use         numerics
      Use         dist_module ! Contains # of proc.s & proc. no.s 

      Integer  :: vsize, n1, n2
      Real(l_) :: a(n2,vsize)
      Integer  :: actsiz(0:nodes-1,2), base(0:nodes-1,2)
      Logical  :: ok

      Real(l_) :: w(n2,vsize)
      Real(l_) :: eps
      Integer  :: i, i1, i2, j, shift
! ---------------------------------------------------------------------
      eps = 4.0_l_*Epsilon( 1.0_l_ )
      shift = base(me,1)
      Do i2 = 1, actsiz(me,1)
         Do i1 = 1, n2
            w(i1,i2) = shift + i2  + ( i1 - 1 )*n1
         End Do
      End Do
      Do j = 1, actsiz(me,1)
         Do i = 1, n2
            ok = ok .AND. ( Abs( a(i,j) - w(i,j) ) < eps )
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine check
