      Subroutine btrans (a, n1, n2, sizes, t)
! -------------------------------------------------------------
! --- 'btrans' performs a blockwise local transposition. Input
!     array is 'a', output array is 't'
! -------------------------------------------------------------
      Use         numerics
      Use         dist_module ! Contains #procs and no.s
      Implicit    None

      Integer  :: n1, n2, sizes(0:nodes-1,2)
      Real(l_) :: a(n1*n2), t(n1*n2)

      Integer  :: m1, m2, b1, b2, i, j, k, l
! -------------------------------------------------------------
      b1 = 0; l = 1; m2 = sizes(me,1)
      Do k = 0, nodes - 1
         m1 = sizes(k,2)
         b2 = 0
         Do i = 1, m2
            Do j = 1, m1
               t(j+b1+b2) = a(l)
               l = l + 1
            End Do
            b2 = b2 + n2
         End Do
         b1 = b1 + m1
      End Do
! -------------------------------------------------------------
      End Subroutine btrans
