      Subroutine mvaxpy( a, b, c, m, n )
! ----------------------------------------------------------------------
! --- Routine 'mvaxpy' does a matrix-vector multiplication 'Ab = c'
!     using a vector update implementation. Somewhat unrolled because
!     most processors/compilers seem to like it.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: m, n
      Real(l_) :: a(m,n), b(n), c(m)

      Integer  :: i, j, nf
! ----------------------------------------------------------------------
      c = 0.0_l_
      nf = n - Mod( n, 8 )
      Do i = 1, nf, 8
         Do j = 1, m
            c(j)= c(j) + a(j,i)  *b(i)   + a(j,i+1)*b(i+1)
     &                 + a(j,i+2)*b(i+2) + a(j,i+3)*b(i+3)
     &                 + a(j,i+4)*b(i+4) + a(j,i+5)*b(i+5)
     &                 + a(j,i+6)*b(i+6) + a(j,i+7)*b(i+7)
            End Do
      End Do
      Do i = nf + 1, n
         Do j = 1, m
            c(j) = c(j) + a(j,i)*b(i)
         End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine mvaxpy
