      Subroutine check( c, m, n, ok )
! ----------------------------------------------------------------------
! --- Routine 'check' does the correctness check for the matrix-vector
!     multiplication in program 'gmxv'. Because of the particular
!     data that are generated, this check can be used. 
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None

      Integer  :: m, n
      Real(l_) :: c(m)
      Logical  :: ok

      Integer  :: i
      Real(l_) :: eps
! ----------------------------------------------------------------------
      eps = 2.0_l_*n*Epsilon( 1.0_l_ )
      Do i = 1, m
         ok = ok .AND. ( Abs( Real( i*n, l_ ) - c(i) ) <= eps )
      End Do
! ----------------------------------------------------------------------
      End Subroutine check
