      Subroutine ping2( title, me, npes, nrpt, ncases, n, tn,
     &                        ops )
! ----------------------------------------------------------------------
      Use            numerics
      Use            max_params      
      Implicit       None
      
      Include        'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer
      Real(l_)     :: a(nmax), b(nmax)      
      Real(l_)     :: t1, t2
      Integer      :: send_pe, recv_pe
      Integer      :: i, k, k2, kk
      Integer      :: comm, ie, tag, type
      Integer      :: st(MPI_Status_Size)
      Save            a, b
! ----------------------------------------------------------------------
      comm   = MPI_Comm_World
      type   = MPI_Real8
      title = ' 1 PE   <--> 1 PE; Bidir.'
      nrpt   = 100
      ncases = npes - 1 
      ops    = 8*n
      i      = 0
      tn (1:ncases) = 0.0_l_ 
      Do k = 0, npes-1
        Do k2 = 0, npes-1
          If ( k /= k2 ) Then
            Call MPI_Barrier( comm, ie )
            If ( me == k ) Then
              Do kk = 1, nrpt
                Call MPI_Sendrecv( a, n, type, k2, kk*2,
     &               b, n, type, k2, (kk*2) +1, comm, st, ie )
              End Do
            End if
            If ( me == k2 ) Then
              i = i + 1
              t1 = timer()
              Do kk = 1, nrpt
                Call MPI_Sendrecv( a, n, type, k, (kk*2)+1,
     &                b, n, type, k, kk*2, comm, st, ie )              
              End Do
              t2 = timer()
              tn(i) = (t2 - t1)/(2*nrpt)
            End if 
          End if
        End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine ping2
