      Subroutine collect( title, me, npes, nrpt, ncases, n, tn,
     &                    ops )
! ----------------------------------------------------------------------
      Use             numerics
      Use             max_params      
      Implicit        None
      
      Include         'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer
      Real(l_)     :: a(nmax), b(nmax)      
      Real(l_)     :: t1, t2
      Integer      :: i, k, kk, kt
      Integer      :: targ_pe
      Integer      :: comm, ie, type
      Save            a, b
! ---------------------------------------------------------------------- 
      comm   = MPI_Comm_World
      type   = MPI_Real8
      title  = ' N PEs  <--> N PEs; Collect'
      nrpt   = 100
      ncases = npes
      ops    = (npes-1)*8*n
     
      If ( n*(npes+1) > nmax ) Then
         ncases = 0
         Return
      End If
      tn(1:ncases) = 0.0_l_      
      Do k = 1, ncases
        b = 0.0_l_

        Call MPI_Barrier( comm, ie )        
        t1 = timer()
        Do kk = 1, nrpt
          call MPI_Gather( a, n, type, b, n, type, k-1, comm, ie )         
        End Do
        t2    = timer()
        tn(k) = (t2 - t1)/nrpt
      End Do
! ---------------------------------------------------------------------- 
      End Subroutine collect
