      Subroutine broadcast( title, me, npes, nrpt, ncases, n, tn,
     &                        ops )
! ----------------------------------------------------------------------
      Use             numerics
      Use             max_params      
      Implicit        None
      
      Include         'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer
      Real(l_)     :: a(nmax), b(nmax)      
      Real(l_)     :: t1, t2
      Integer      :: k, kk, n_er
      Integer      :: targ_pe, log2
      Integer      :: comm, ie, type
      Save            a, b
! ---------------------------------------------------------------------- 
      comm   = MPI_Comm_World
      type   = MPI_Real8
      title  = ' 1 PE    --> N PEs; Broadcast'
      nrpt   = 100
      ncases = npes
      ops    = log2(npes - 1)*8*n        
      tn(1:ncases) = 0.0_l_     
      Do k = 0, npes-1
         b = 0.0_l_

         Call MPI_Barrier( comm, ie )
         t1 = timer()
         Do kk = 1,nrpt
            Call MPI_Bcast( b, n, type, k, comm, ie )
         End Do
         t2      = timer()
         tn(k+1) = (t2 - t1)/nrpt
      End Do
! ---------------------------------------------------------------------- 
      End Subroutine broadcast
