      SUBROUTINE MKNOT2(X,T,N,K,MODE,Q,A,DBCOEF,BCOEF)
      Use numerics
! ----------------------------------------------------------------------
C
C MKNOT2 CONSTRUCTS A CONDENSED FORM OF THE MATRIX OF THE LINEAR
C SYSTEM WHICH IS TO BE SOLVED IN ORDER TO DETERMINE THE COEFFICIENTS OF
C THE B-REPRESENTATION OF THE K-TH ORDER SPLINE WHICH INTERPOLATES
C THE POINTS X(I),Y(I), I=0,...,N-1.
C IT ALSO PRODUCES THE KNOT SEQUENCE T BY WHICH THE B-SPLINES ARE
C DEFINED.
C THE SYSTEM IS CONSTRUCTED FROM THE EQUATIONS
C F(X(I))=Y(I), I=0,...,N-1, TOGETHER WITH ADDITIONAL INFORMATION,
C VIZ.:
C - IF MODE .EQ. BUILT: 1'ST UP TO K/2-1'TH DERIVATIVES OF F ARE GIVEN
C                       IN THE ENDPOINTS X(0),X(N-1).
C - IF MODE .EQ. FREE:  2'ND UP TO K-1'TH DERIVATIVES OF F ARE 0
C                       IN THE ENDPOINTS X(0),X(N-1).
C
C INPUT:
C   X     : REAL(0:N-1)  ABSCISSAE OF SEQUENCE TO BE INTERPOLATED.
C   N     : LENGTH OF THIS SEQUENCE.
C   MODE  : MODE OF ENDPOINT CONDITIONS.
C   Q     : REAL(0:2*K-2,0:N+K-3)  ZEROED ARRAY TO BE FILLED WITH
C           THE DIAGONALS OF THE MATRIX.
C
C  WORK AREA:
C   A     : REAL(0:K-1,0:K-1) ARRAY TO CONTAIN THE COEFFICIENTS OF THE
C           B-SPLINE DERIVATIVES.
C   DY    : REAL(0:K-1,0:K-1) ARRAY TO CONTAIN THE VALUES OF THE NON-
C           ZERO B-SPLINES AT THE POINTS X(I), I=0,...,N-1.
C
C OUTPUT:
C   Q     : REAL(0:2*K-2,0:N+K-3) ARRAY TO CONTAIN THE NON-ZERO
C           DIAGONALS OF THE MATRIX.
C
C MKNOT2 CALLS BSPLVB AND BSPLVD.
C
! ----------------------------------------------------------------------
      Real(l_) :: X(0:N-1),T(0:N+2*K-3)
      Real(l_) :: Q(0:2*K-2,0:N+K-3),BCOEF(0:N+K-3)
      Character *(*) MODE

      Real(l_) :: A(0:K-1,0:K-1),DBCOEF(0:K-1,0:K-1)
      Integer  :: M,NL,NR,I,J,DELTA,DIAG,LEFT,NDERIV,BASDIM,START
! ----------------------------------------------------------------------
C CONSTRUCTION OF THE KNOT SEQUENCE:
      BASDIM = N+K-2
      DO 10 I=0,K-2
         T(I) = X(0) - 1.0
         T(BASDIM+I+1) = X(N-1) + 1.0
10    CONTINUE

      DO 20 I=0,N-1
         T(K+I-1) = X(I)
20    CONTINUE

C (K-2) ADDITIONAL RELATIONS ARE NEEDED:
C IF 'MODE' .EQ. 'FREE', THEN THE NL DERIVATIVES
C OF ORDER 2,...,NL+1 IN X(0) , AND
C THE NR DERIVATIVES OF ORDER 2,...,NR+1 IN X(N-1) ARE CHOSEN
C TO BE ZERO.
C IF 'MODE' .EQ. 'BUILT', THEN THE NL DERIVATIVES
C OF ORDER 1,...,NL IN X(0), AND THE NR DERIVATIVES
C OF ORDER 1,...,NR IN X(N-1) ARE ASSUMED TO BE GIVEN.
C NL AND NR ARE DETERMINED AS FOLLOWS:

      M=K/2 + MOD(K,2)
      NL=M-1
      NR=K-2-NL

      LEFT=K-1
      DIAG=K-1

C DERIVATIVES AT X(0):
      IF (MODE .EQ. 'BUILT') THEN
         NDERIV=NL+1
         START=1
      ELSE
         IF (MODE .EQ. 'FREE') THEN
            NDERIV=NL+2
            START=2
         END IF
      END IF
      CALL BSPLVD(T,K,X(0),LEFT+1,A,DBCOEF,NDERIV)

      DO 30 J=START,NDERIV-1
         DELTA=0
         DO 35 I=0,K-2
            Q(DIAG-DELTA,I) = DBCOEF(I,J)
            DELTA=DELTA+1
35       CONTINUE
         DIAG=DIAG+1
30    CONTINUE

C B-SPLINE VALUES AT X(0):
      DELTA=0
      DO 40 I=0,K-1
         Q(DIAG-DELTA,I)=DBCOEF(I,0)
         DELTA=DELTA+1
40    CONTINUE

C B-SPLINE VALUES AT X(1),...,X(N-2):
      LEFT=LEFT+1
      DO 50 L=1,N-2
         CALL BSPLVB(T,K,1,X(L),LEFT+1,BCOEF)
         DELTA=0
         DO 55 I=L,L+(K-2)
            Q(DIAG-DELTA,I)=BCOEF(I-L)
            DELTA=DELTA+1
55       CONTINUE
         LEFT=LEFT+1
50    CONTINUE

C B-SPLINE VALUES AT X(N-1):
      IF (MODE .EQ. 'BUILT') THEN
         NDERIV=NR+1
         START=1
      ELSE
         IF (MODE .EQ. 'FREE') THEN
            NDERIV=NR+2
            START=2
         END IF
      END IF
      LEFT=LEFT-1
      CALL BSPLVD(T,K,X(N-1),LEFT+1,A,DBCOEF,NDERIV)
      DELTA=0
      DO 60 I=N-1,BASDIM-1
         Q(DIAG-DELTA,I)=DBCOEF(I-N+2,0)
         DELTA=DELTA+1
60    CONTINUE

C DERIVATIVES AT X(N-1):
      DO 70 J=START,NDERIV-1
         DELTA=0
         DIAG=DIAG+1
         DO 75 I=N-1,BASDIM-1
            Q(DIAG-DELTA,I)=DBCOEF(I-N+2,J)
            DELTA=DELTA+1
75       CONTINUE
70    CONTINUE

      RETURN
      END
