      SUBROUTINE INTERV(XT, LXT, X, LEFT, MFLAG)
! ----------------------------------------------------------------------
      Use numerics
C
C OMPUTES LEFT = MAX(I,1 .LE. I..LE. LXT .AND. XT(I) .LE. X) .
C
C ******  I N P U T  *****
C  XT.....A REAL SEQUENCE, OF LENGTH LXT, ASSUMED TO BE NONDECREASING
C  LXT.....NUMBER OF TERMS IN SEQUENCE XT.
C  X.....THE POINT WHOSE LOCATION WITH RESPECT TO THE SEQUENCE XT IS
C        TO BE DETERMINED
C
C ******  O U T P U T  ******
C  LEFT, MFLAG.....BOTH INTEGERS, WHOSE VALUE IS
C   1     -1      IF              X .LT. XT(1)
C   I      0      IF  XT(I) .LE.  X .LT. XT(I+1)
C  LXT     1      IF XT(LXT) .LE. X
C        IN PARTICULAR, MFLAG = 0 IS THE 'USUAL' CASE. MFLAG .NE. 0
C        INDICATES THAT  X  LIES OUTSIDE THE HALFOPEN INTERVAL
C        XT(1) .LE. Y .LT. XT(LXT) . THE ASYMMETRIC TREATMENT OF THE
C        INTERVAL IS DUE TO THE DECISION TO MAKE ALL PP FUNCTIONS CONT-
C        INUOUS FROM THE RIGHT
C
C ******  M E T H O D  ******
C  THE PROGRAM IS DESIGNED TO BE EFFICIENT IN THE COMMON SITUATION THAT
C  IT IS CALLED REPEATEDLY, WITH  X  TAKEN FROM AN INCREASING OR DECREA-
C  SING SEQUENCE. THIS WILL HAPPEN, E.G., WHEN A PP FUNCTION IS TO BE
C  GRAPHED. THE FIRST GUESS FOR LEFT IS THEREFORE TAKEN TO BE THE VAL-
C  UE RETURNED AT THE PREVIOUS CALL AND STORED IN THE L O C A L  VARIA-
C  BLE ILO. A FIRST CHECK ASCERTAINS THAT ILO .LT. LXT (THIS IS NEC
C  ESSARY SINCE THE PRESENT CALL MAY HAVE NOTHING TO DO WITH THE PREVI-
C  OUS CALL). THEN, IF  XT(ILO) .LE. X .LT. XT(ILO+1), WE SET LEFT =
C  ILO AND ARE DONE AFTER JUST THREE COMPARISONS,
C      OTHERWISE, WE REPEATEDLY DOUBLE THE DIFFERENCE ISTEP = IHI - ILO
C  WHILE ALSO MOVING ILO AND IHI IN THE DIRECTION OF  X , UNTIL
C                     XT(ILO) .LE. X .LT. XT(IHI) ,
C  AFTER WHICH WE USE BISECTION TO GET, IN ADDITION, ILO+1 = IHI.
C  LEFT = ILO  IS THEN RETURNED.
! ----------------------------------------------------------------------
      Integer  :: LEFT, LXT, MFLAG, IHI, ILO, ISTEP, MIDDLE
      Real(l_) :: X, XT(LXT)
      Data        ilo /1/
      Save        ilo
! ----------------------------------------------------------------------
      IHI = ILO + 1
      IF (IHI.LT.LXT) GO TO 10
      IF (X.GE.XT(LXT)) GO TO 110
      IF (LXT.LE.1) GO TO 90
      ILO = LXT - 1
      IHI = LXT
   10 IF (X.GE.XT(IHI)) GO TO 40
      IF (X.GE.XT(ILO)) GO TO 100
C
C ****NOW X .LT. X(ILO) .DECREASE ILO TO CAPTURE X .
C
      ISTEP = 1
   20 IHI = ILO
      ILO = IHI - ISTEP
      IF (ILO.LE.1) GO TO 30
      IF (X.GE.XT(ILO)) GO TO 70
      ISTEP = ISTEP*2
      GO TO 20
   30 ILO = 1
      IF (X.LT.XT(1)) GO TO 90
      GO TO 70
C
C ****NOW X .GE. XT(IHI) .INCREASE IHI TO CAPTURE X .
C
   40 ISTEP = 1
   50 IHI = ILO + ISTEP
      IF (IHI.GE.LXT) GO TO 60
      IF (X.LT.XT(IHI)) GO TO 70
      ISTEP = ISTEP*2
      GO TO 50
   60 IF (X.GE.XT(LXT)) GO TO 110
      IHI = LXT
C
C ****NOW XT(ILO) .LE. X .LT. XT(IHI .NARROW THE INTERVAL .
C
   70 MIDDLE = (ILO+IHI)/2
      IF (MIDDLE.EQ.ILO) GO TO 100
C
C NOTE. IT IS ASSUMED THAT MIDDLE = ILO IN CASE IHI = ILO + 1
C
      IF (X.LT.XT(MIDDLE)) GO TO 80
      ILO = MIDDLE
      GO TO 70
   80 IHI = MIDDLE
      GO TO 70
C
C **** SET OUTPUT AND RETURN.
C
   90 MFLAG = -1
      LEFT = 1
      RETURN
  100 MFLAG = 0
      LEFT = ILO
      RETURN
  110 MFLAG = 1
      LEFT = LXT
      RETURN
      END
