      FUNCTION BVALUE(T, BCOEF, N, K, X, JDERIV)    Result( result )
      Use numerics
! ----------------------------------------------------------------------
C  FROM  * A PRACTICAL GUIDE TO SPLINES *  BY C. DE BOOR
C ALLS  INTERV
C
C ALCULATES VALUE AT  X  OF  JDERIV-TH DERIVATIVE OF SPLINE FROM B-REPR.
C  THE SPLINE IS TAKEN TO BE CONTINUOUS FROM THE RIGHT.
C
C ******  I N P U T ******
C  T, BCOEF, N, K......FORMS THE B-REPRESENTATION OF THE SPLINE  F  TO
C        BE EVALUATED. SPECIFICALLY,
C  T.....KNOT SEQUENCE, OF LENGTH  N+K, ASSUMED NONDECREASING.
C  BCOEF.....B-COEFFICIENT SEQUENCE, OF LENGTH  N .
C  N.....LENGTH OF  BCOEF  AND DIMENSION OF SPLINE(K,T),
C        A S S U M E D  POSITIVE .
C  K.....ORDER OF THE SPLINE .
C  W A R N I N G . . .   THE RESTRICTION  K .LE. KMAX (=20)  IS IMPOSED
C        ARBITRARILY BY THE DIMENSION STATEMENT FOR  AJ, DL, DR  BELOW,
C        BUT IS  N O W H E R E  C H E C K E D  FOR.
C  X.....THE POINT AT WHICH TO EVALUATE .
C  JDERIV.....INTEGER GIVING THE ORDER OF THE DERIVATIVE TO BE EVALUATED
C        A S S U M E D  TO BE ZERO OR POSITIVE.
C ******  O U T P U T  ******
C  BVALUE.....THE VALUE OF THE (JDERIV)-TH DERIVATIVE OF  F  AT  X .
C
C ******  M E T H O D  ******
C     THE NONTRIVIAL KNOT INTERVAL  (T(I),T(I+1))  CONTAINING  X  IS LO-
C  CATED WITH THE AID OF  INTERV . THE  K  B-COEFFS OF  F  RELEVANT FOR
C  THIS INTERVAL ARE THEN OBTAINED FROM  BCOEF (OR TAKEN TO BE ZERO IF
C  NOT EXPLICITLY AVAILABLE) AND ARE THEN DIFFERENCED  JDERIV  TIMES TO
C  OBTAIN THE B-COEFFS OF  (D**JDERIV)F  RELEVANT FOR THAT INTERVAL.
C  PRECISELY, WITH  J = JDERIV, WE HAVE FROM X.(12) OF THE TEXT THAT
C     (D**J)F  =  SUM ( BCOEF(.,J)*B(.,K-J,T) )
C  WHERE
C                   / BCOEF(.),                     ,  J .EQ. 0
C                   /
C    BCOEF(.,J)  =  / BCOEF(.,J-1) - BCOEF(.-1,J-1)
C                   / ----------------------------- ,  J .GT. 0
C                   /    (T(.+K-J) - T(.))/(K-J)
C     THEN, WE USE REPEATEDLY THE FACT THAT
C    SUM ( A(.)*B(.,M,T)(X) )  =  SUM ( A(.,X)*B(.,M-1,T)(X) )
C  WITH
C                 (X - T(.))*A(.) + (T(.+M-1) - X)*A(.-1)
C    A(.,X)  =    ---------------------------------------
C                 (X - T(.))      + (T(.+M-1) - X)
C  TO WRITE  (D**J)F(X)  EVENTUALLY AS A LINEAR COMBINATION OF B-SPLINES
C  OF ORDER  1 , AND THE COEFFICIENT FOR  B(I,1,T)(X)  MUST THEN BE THE
C  DESIRED NUMBER  (D**J)F(X). (SEE X.(17)-(19) OF TEXT).
C     PARAMETER KMAX = 20
C
! ----------------------------------------------------------------------
      Integer  :: JDERIV, K, N, I, ILO, IMK, J, JC, JCMIN, JCMAX, JJ,
     &            KMJ, KM1, MFLAG, NMI, JDRVP1
      Real(l_) :: BCOEF(N), T(1), X, AJ(20), DL(20), DR(20), FKMJ,
     &            result
! ----------------------------------------------------------------------
      result = 0.0_l_
      IF (JDERIV.GE.K) GO TO 190
C
C *** FIND  I   S.T.   1 .LE. I .LT. N+K   AND   T(I) .LT. T(I+1)   AND
C     T(I) .LE. X .LT. T(I+1) . IF NO SUCH I CAN BE FOUND,  X  LIES
C     OUTSIDE THE SUPPORT OF  THE SPLINE  F  AND  result = 0.
C     (THE ASYMMETRY IN THIS CHOICE OF  I  MAKES  F  RIGHTCONTINUOUS)
C
      CALL INTERV(T, N+K, X, I, MFLAG)
      IF (MFLAG.NE.0) GO TO 190
C
C *** IF K = 1 (AND JDERIV = 0), result = BCOEF(I).
C
      KM1 = K - 1
      IF (KM1.GT.0) GO TO 10
      result = BCOEF(I)
      GO TO 190
C
C *** STORE THE K B-SPLINE COEFFICIENTS RELEVANT FOR THE KNOT INTERVAL
C    (T(I),T(I+1)) IN AJ(1),...,AJ(K) AND COMPUTE DL(J) = X - T(I+1-J),
C    DR(J) = T(I+J) - X, J=1,...,K-1 . SET ANY OF THE AJ NOT OBTAINABLE
C    FROM INPUT TO ZERO. SET ANY T.S NOT OBTAINABLE EQUAL TO T(1) OR
C    TO T(N+K) APPROPRIATELY.
C
   10 JCMIN = 1
      IMK = I - K
      IF (IMK.GE.0) GO TO 40
      JCMIN = 1 - IMK
      DO 20 J=1,I
         DL(J) = X - T(I+1-J)
   20 CONTINUE
      DO 30 J=I,KM1
         AJ(K-J) = 0.
         DL(J) = DL(I)
   30 CONTINUE
      GO TO 60
   40 DO 50 J=1,KM1
         DL(J) = X - T(I+1-J)
   50 CONTINUE
   60 JCMAX = K
      NMI = N - I
      IF (NMI.GE.0) GO TO 90
      JCMAX = K + NMI
      DO 70 J=1,JCMAX
         DR(J) = T(I+J) - X
   70 CONTINUE
      DO 80 J=JCMAX,KM1
         AJ(J+1) = 0.
         DR(J) = DR(JCMAX)
   80 CONTINUE
      GO TO 110
   90 DO 100 J=1,KM1
         DR(J) = T(I+J) - X
  100 CONTINUE
  110 DO 120 JC=JCMIN,JCMAX
         AJ(JC) = BCOEF(IMK+JC)
  120 CONTINUE
C
C *** DIFFERENCE THE COEFFICIENTS  JDERIV  TIMES.
C
      IF (JDERIV.EQ.0) GO TO 150
      DO 140 J=1,JDERIV
         KMJ = K - J
         FKMJ = FLOAT(KMJ)
         ILO = KMJ
         DO 130 JJ=1,KMJ
            AJ(JJ) = ((AJ(JJ+1)-AJ(JJ))/(DL(ILO)+DR(JJ)))*FKMJ
            ILO = ILO - 1
  130    CONTINUE
  140 CONTINUE
C
C *** COMPUTE VALUE AT  X  IN (T(I),T(I+1)) OF JDERIV-TH DERIVATIVE,
C    GIVEN ITS RELEVANT B-SPLINE COEFFS IN AJ(1),...,AJ(K-JDERIV).
C
  150 IF (JDERIV.EQ.KM1) GO TO 180
      JDRVP1 = JDERIV + 1
      DO 170 J=JDRVP1,KM1
         KMJ = K - J
         ILO = KMJ
         DO 160 JJ=1,KMJ
            AJ(JJ) = (AJ(JJ+1)*DL(ILO)+AJ(JJ)*DR(JJ))/(DL(ILO)+DR(JJ))
            ILO = ILO - 1
  160    CONTINUE
  170 CONTINUE
  180 result = AJ(1)
  190 RETURN
      END
