      SUBROUTINE BSPLVD ( T, K, X, LEFT, A, DBIATX, NDERIV )
      Use numerics
! ----------------------------------------------------------------------
C  FROM  * A PRACTICAL GUIDE TO SPLINES *  BY C. DE BOOR
CALLS BSPLVB
CALCULATES VALUE AND DERIV.S OF ALL B-SPLINES WHICH DO NOT VANISH AT X
C
C******  I N P U T  ******
C  T     THE KNOT ARRAY, OF LENGTH LEFT+K (AT LEAST)
C  K     THE ORDER OF THE B-SPLINES TO BE EVALUATED
C  X     THE POINT AT WHICH THESE VALUES ARE SOUGHT
C  LEFT  AN INTEGER INDICATING THE LEFT ENDPOINT OF THE INTERVAL OF
C        INTEREST. THE  K  B-SPLINES WHOSE SUPPORT CONTAINS THE INTERVAL
C               (T(LEFT), T(LEFT+1))
C        ARE TO BE CONSIDERED.
C  A S S U M P T I O N  - - -  IT IS ASSUMED THAT
C               T(LEFT) .LT. T(LEFT+1)
C        DIVISION BY ZERO WILL RESULT OTHERWISE (IN  B S P L V B ).
C        ALSO, THE OUTPUT IS AS ADVERTISED ONLY IF
C               T(LEFT) .LE. X .LE. T(LEFT+1) .
C  NDERIV   AN INTEGER INDICATING THAT VALUES OF B-SPLINES AND THEIR
C        DERIVATIVES UP TO BUT NOT INCLUDING THE  NDERIV-TH  ARE ASKED
C        FOR. ( NDERIV  IS REPLACED INTERNALLY BY THE INTEGER  M H I G H
C        IN  (1,K)  CLOSEST TO IT.)
C
C******  W O R K   A R E A  ******
C  A     AN ARRAY OF ORDER (K,K), TO CONTAIN B-COEFF.S OF THE DERIVAT-
C        IVES OF A CERTAIN ORDER OF THE  K  B-SPLINES OF INTEREST.
C
C******  O U T P U T  ******
C  DBIATX   AN ARRAY OF ORDER (K,NDERIV). ITS ENTRY  (I,M)  CONTAINS
C        VALUE OF  (M-1)ST  DERIVATIVE OF  (LEFT-K+I)-TH  B-SPLINE OF
C        ORDER  K  FOR KNOT SEQUENCE  T , I=M,...,K, M=1,...,NDERIV.
C
C******  M E T H O D  ******
C  VALUES AT  X  OF ALL THE RELEVANT B-SPLINES OF ORDER K,K-1,...,
C  K+1-NDERIV  ARE GENERATED VIA  BSPLVB  AND STORED TEMPORARILY IN
C  DBIATX .  THEN, THE B-COEFFS OF THE REQUIRED DERIVATIVES OF THE B-
C  SPLINES OF INTEREST ARE GENERATED BY DIFFERENCING, EACH FROM THE PRE-
C  CEDING ONE OF LOWER ORDER, AND COMBINED WITH THE VALUES OF B-SPLINES
C  OF CORRESPONDING ORDER IN  DBIATX  TO PRODUCE THE DESIRED VALUES.
! ----------------------------------------------------------------------
      Integer  :: K,LEFT,NDERIV,   I,IDERIV,IL,J,JLOW,JP1MID,KP1,KP1MM
     &                        ,LDUMMY,M,MHIGH
      Real(l_) :: A(K,K),DBIATX(K,NDERIV),T(1),X,   FACTOR,FKP1MM,SUM
! ----------------------------------------------------------------------
      MHIGH = MAX0(MIN0(NDERIV,K),1)
C     MHIGH IS USUALLY EQUAL TO NDERIV.
      KP1 = K+1
      CALL BSPLVB(T,KP1-MHIGH,1,X,LEFT,DBIATX)
      IF (MHIGH .EQ. 1)                 GO TO 99
C     THE FIRST COLUMN OF  DBIATX  ALWAYS CONTAINS THE B-SPLINE VALUES
C     FOR THE CURRENT ORDER. THESE ARE STORED IN COLUMN K+1-CURRENT
C     ORDER  BEFORE  BSPLVB  IS CALLED TO PUT VALUES FOR THE NEXT
C     HIGHER ORDER ON TOP OF IT.
      IDERIV = MHIGH
      DO 15 M=2,MHIGH
         JP1MID = 1
         DO 11 J=IDERIV,K
            DBIATX(J,IDERIV) = DBIATX(JP1MID,1)
   11       JP1MID = JP1MID + 1
         IDERIV = IDERIV - 1
         CALL BSPLVB(T,KP1-IDERIV,2,X,LEFT,DBIATX)
   15    CONTINUE
C
C     AT THIS POINT,  B(LEFT-K+I, K+1-J)(X) IS IN  DBIATX(I,J) FOR
C     I=J,...,K AND J=1,...,MHIGH ('=' NDERIV). IN PARTICULAR, THE
C     FIRST COLUMN OF  DBIATX  IS ALREADY IN FINAL FORM. TO OBTAIN COR-
C     RESPONDING DERIVATIVES OF B-SPLINES IN SUBSEQUENT COLUMNS, GENE-
C     RATE THEIR B-REPR. BY DIFFERENCING, THEN EVALUATE AT  X.
C
      JLOW = 1
      DO 20 I=1,K
         DO 19 J=JLOW,K
   19       A(J,I) = 0.
         JLOW = I
   20    A(I,I) = 1.
C     AT THIS POINT, A(.,J) CONTAINS THE B-COEFFS FOR THE J-TH OF THE
C     K  B-SPLINES OF INTEREST HERE.
C
      DO 40 M=2,MHIGH
         KP1MM = KP1 - M
         FKP1MM = FLOAT(KP1MM)
         IL = LEFT
         I = K
C
C        FOR J=1,...,K, CONSTRUCT B-COEFFS OF  (M-1)ST  DERIVATIVE OF
C        B-SPLINES FROM THOSE FOR PRECEDING DERIVATIVE BY DIFFERENCING
C        AND STORE AGAIN IN  A(.,J) . THE FACT THAT  A(I,J) = 0  FOR
C        I .LT. J  IS USED.
         DO 25 LDUMMY=1,KP1MM
            FACTOR = FKP1MM/(T(IL+KP1MM) - T(IL))
C           THE ASSUMPTION THAT T(LEFT).LT.T(LEFT+1) MAKES DENOMINATOR
C           IN  FACTOR  NONZERO.
            DO 24 J=1,I
   24          A(I,J) = (A(I,J) - A(I-1,J))*FACTOR
            IL = IL - 1
   25       I = I - 1
C
C        FOR I=1,...,K, COMBINE B-COEFFS A(.,I) WITH B-SPLINE VALUES
C        STORED IN DBIATX(.,M) TO GET VALUE OF  (M-1)ST  DERIVATIVE OF
C        I-TH B-SPLINE (OF INTEREST HERE) AT  X , AND STORE IN
C        DBIATX(I,M). STORAGE OF THIS VALUE OVER THE VALUE OF A B-SPLINE
C        OF ORDER M THERE IS SAFE SINCE THE REMAINING B-SPLINE DERIVAT-
C        IVES OF THE SAME ORDER DO NOT USE THIS VALUE DUE TO THE FACT
C        THAT  A(J,I) = 0  FOR J .LT. I .
convex   30    DO 40 I=1,K
         do 40 i=1,k
            SUM = 0.
            JLOW = MAX0(I,M)
            DO 35 J=JLOW,K
   35          SUM = A(J,I)*DBIATX(J,M) + SUM
   40       DBIATX(I,M) = SUM
   99                                   RETURN
      END
