      SUBROUTINE BSPLVB(T, JHIGH, INDEX, X, LEFT, BIATX)
! ---------------------------------------------------------------------
      Use numerics
C
C  FROM  * A PRACTICAL GUIDE TO SPLINES *  BY C. DE BOOR
C ALCULATES THE VALUE OF ALL POSSIBLY NONZERO B-SPLINES AT  X  OF ORDER
C             JOUT  =  MAX( JHIGH , (J+1)*(INDEX-1) )
C  WITH KNOT SEQUENCE  T .
C
C ******  I N P U T  ******
C  T.....KNOT SEQUENCE, OF LENGTH  LEFT + JOUT  , ASSUMED TO BE NONDE-
C      CREASING.  A S S U M P T I O N . . . .
C                     T(LEFT)  .LT.  T(LEFT + 1)   .
C   D I V I S I O N  B Y  Z E R O  WILL RESULT IF  T(LEFT) = T(LEFT+1)
C  JHIGH,
C  INDEX.....INTEGERS WHICH DETERMINE THE ORDER  JOUT = MAX(JHIGH,
C      (J+1)*(INDEX-1))  OF THE B-SPLINES WHOSE VALUES AT  X  ARE TO
C      BE RETURNED.  INDEX  IS USED TO AVOID RECALCULATIONS WHEN SEVE-
C      RAL COLUMNS OF THE TRIANGULAR ARRAY OF B-SPLINE VALUES ARE NEE-
C      DED (E.G., IN  BVALUE  OR IN  BSPLVD ). PRECISELY,
C                   IF  INDEX = 1 ,
C      THE CALCULATION STARTS FROM SCRATCH AND THE ENTIRE TRIANGULAR
C      ARRAY OF B-SPLINE VALUES OF ORDERS 1,2,...,JHIGH  IS GENERATED
C      ORDER BY ORDER , I.E., COLUMN BY COLUMN .
C                   IF  INDEX = 2 ,
C      ONLY THE B-SPLINE VALUES OF ORDER  J+1, J+2, ..., JOUT  ARE GE-
C      NERATED, THE ASSUMPTION BEING THAT  BIATX , J , DELTAL , DELTAR
C      ARE, ON ENTRY, AS THEY WERE ON EXIT AT THE PREVIOUS CALL.
C         IN PARTICULAR, IF  JHIGH = 0, THEN  JOUT = J+1, I.E., JUST
C      THE NEXT COLUMN OF B-SPLINE VALUES IS GENERATED.
C  W A R N I N G . . .  THE RESTRICTION   JOUT .LE. JMAX (= 20)  IS IM-
C      POSED ARBITRARILY BY THE DIMENSION STATEMENT FOR  DELTAL  AND
C      DELTAR  BELOW, BUT IS  N O W H E R E  C H E C K E D  FOR .
C  X.....THE POINT AT WHICH THE B-SPLINES ARE TO BE EVALUATED.
C  LEFT.....AN INTEGER CHOSEN (USUALLY) SO THAT
C                T(LEFT) .LE. X .LE. T(LEFT+1)  .
C
C ******  O U T P U T  ******
C  BIATX.....ARRAY OF LENGTH  JOUT , WITH  BIATX(I)  CONTAINING THE VAL-
C      UE AT  X  OF THE POLYNOMIAL OF ORDER  JOUT  WHICH AGREES WITH
C      THE B-SPLINE  B(LEFT-JOUT+I,JOUT,T)  ON THE INTERVAL (T(LEFT),
C      T(LEFT+1)) .
C
C ******  M E T H O D  ******
C  THE RECURRENCE RELATION
C                     X - T(I)              T(I+J+1) - X
C     B(I,J+1)(X)  =  -----------B(I,J)(X) + ---------------B(I+1,J)(X)
C                   T(I+J)-T(I)            T(I+J+1)-T(I+1)
C  IS USED (REPEATEDLY) TO GENERATE THE (J+1)-VECTOR  B(LEFT-J,J+1)(X),
C  ...,B(LEFT,J+1)(X)  FROM THE J-VECTOR  B(LEFT-J+1,J)(X),...,
C  B(LEFT,J)(X), STORING THE NEW VALUES IN  BIATX  OVER THE OLD. THE
C  FACTS THAT
C          B(I,1) = 1  IF  T(I) .LE. X .LT. T(I+1)
C  AND THAT
C          B(I,J)(X) = 0  UNLESS  T(I) .LE. X .LT. T(I+J)
C  ARE USED. THE PARTICULAR ORGANIZATION OF THE CALCULATIONS FOLLOWS AL-
C  GORITHM  (8)  IN CHAPTER X OF THE TEXT.
C     PARAMETER JMAX = 20
C
! ---------------------------------------------------------------------
      Integer :: index, jhigh, left, i, j, jp1
      Real(l_) :: biatx(jhigh), t(1), x, deltal(20), deltar(20), saved,
     &            term
      Save        j, deltal, deltar
      Data        j /1/
! ---------------------------------------------------------------------
      GO TO (10, 20), INDEX
   10 J = 1
      BIATX(1) = 1.
      IF (J.GE.JHIGH) GO TO 40
   20 JP1 = J + 1
      DELTAR(J) = T(LEFT+J) - X
      DELTAL(J) = X - T(LEFT+1-J)
      SAVED = 0.
      DO 30 I=1,J
         TERM = BIATX(I)/(DELTAR(I)+DELTAL(JP1-I))
         BIATX(I) = SAVED + DELTAR(I)*TERM
         SAVED = DELTAL(JP1-I)*TERM
   30 CONTINUE
      BIATX(JP1) = SAVED
      J = JP1
      IF (J.LT.JHIGH) GO TO 20
   40 RETURN
      END
